/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import io.prestosql.server.security.PasswordAuthenticatorManager;
import io.prestosql.server.security.SecurityConfig;
import io.prestosql.server.ui.FormAuthenticator;
import io.prestosql.spi.security.AccessDeniedException;
import java.util.Objects;
import javax.inject.Inject;

public class PasswordManagerFormAuthenticator
implements FormAuthenticator {
    private final PasswordAuthenticatorManager passwordAuthenticatorManager;
    private final boolean insecureAuthenticationOverHttpAllowed;

    @Inject
    public PasswordManagerFormAuthenticator(PasswordAuthenticatorManager passwordAuthenticatorManager, SecurityConfig securityConfig) {
        this.passwordAuthenticatorManager = Objects.requireNonNull(passwordAuthenticatorManager, "passwordAuthenticatorManager is null");
        passwordAuthenticatorManager.setRequired();
        this.insecureAuthenticationOverHttpAllowed = Objects.requireNonNull(securityConfig, "securityConfig is null").isInsecureAuthenticationOverHttpAllowed();
    }

    @Override
    public boolean isLoginEnabled(boolean secure) {
        if (secure) {
            return true;
        }
        return this.insecureAuthenticationOverHttpAllowed;
    }

    @Override
    public boolean isPasswordAllowed(boolean secure) {
        return secure;
    }

    @Override
    public boolean isValidCredential(String username, String password, boolean secure) {
        if (username == null) {
            return false;
        }
        if (!secure) {
            return this.insecureAuthenticationOverHttpAllowed && password == null;
        }
        try {
            this.passwordAuthenticatorManager.getAuthenticator().createAuthenticatedPrincipal(username, password);
            return true;
        }
        catch (AccessDeniedException e) {
            return false;
        }
    }
}

