/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.io.Resources;
import io.prestosql.server.security.ResourceSecurity;
import io.prestosql.server.ui.FormWebUiAuthenticationFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;

@Path(value="")
public class LoginResource {
    private static final String REPLACEMENT_TEXT = "var hidePassword = false; // This value will be replaced";
    private final FormWebUiAuthenticationFilter formWebUiAuthenticationManager;
    private final String loginHtml;

    @Inject
    public LoginResource(FormWebUiAuthenticationFilter formWebUiAuthenticationManager) throws IOException {
        this.formWebUiAuthenticationManager = Objects.requireNonNull(formWebUiAuthenticationManager, "formWebUiAuthenticationManager is null");
        this.loginHtml = Resources.toString((URL)this.getClass().getResource("/webapp/login.html"), (Charset)StandardCharsets.UTF_8);
        Verify.verify((boolean)this.loginHtml.contains(REPLACEMENT_TEXT), (String)"login.html does not contain the replacement text", (Object[])new Object[0]);
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    @Path(value="/ui/login.html")
    public Response getFile(@Context SecurityContext securityContext) {
        boolean passwordAllowed = this.formWebUiAuthenticationManager.isPasswordAllowed(securityContext.isSecure());
        return Response.ok((Object)this.loginHtml.replace(REPLACEMENT_TEXT, "var hidePassword = " + !passwordAllowed + ";")).type("text/html").build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @POST
    @Path(value="/ui/login")
    public Response login(@FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="redirectPath") String redirectPath, @Context SecurityContext securityContext) {
        username = Strings.emptyToNull((String)username);
        password = Strings.emptyToNull((String)password);
        redirectPath = Strings.emptyToNull((String)redirectPath);
        if (!this.formWebUiAuthenticationManager.isAuthenticationEnabled(securityContext.isSecure())) {
            return Response.seeOther((URI)FormWebUiAuthenticationFilter.DISABLED_LOCATION_URI).build();
        }
        Optional<NewCookie> authenticationCookie = this.formWebUiAuthenticationManager.checkLoginCredentials(username, password, securityContext.isSecure());
        if (!authenticationCookie.isPresent()) {
            return Response.seeOther((URI)FormWebUiAuthenticationFilter.LOGIN_FORM_URI).build();
        }
        return FormWebUiAuthenticationFilter.redirectFromSuccessfulLoginResponse(redirectPath).cookie(new NewCookie[]{authenticationCookie.get()}).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    @Path(value="/ui/logout")
    public Response logout(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @Context SecurityContext securityContext) {
        URI redirectLocation = this.formWebUiAuthenticationManager.isAuthenticationEnabled(securityContext.isSecure()) ? FormWebUiAuthenticationFilter.LOGIN_FORM_URI : FormWebUiAuthenticationFilter.DISABLED_LOCATION_URI;
        return Response.seeOther((URI)redirectLocation).cookie(new NewCookie[]{FormWebUiAuthenticationFilter.getDeleteCookie(securityContext.isSecure())}).build();
    }
}

