/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.ui;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.dispatcher.DispatchManager;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.scheduler.NodeSchedulerConfig;
import io.prestosql.memory.ClusterMemoryManager;
import io.prestosql.metadata.InternalNodeManager;
import io.prestosql.metadata.NodeState;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.security.ResourceSecurity;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/ui/api/stats")
public class ClusterStatsResource {
    private final InternalNodeManager nodeManager;
    private final DispatchManager dispatchManager;
    private final boolean isIncludeCoordinator;
    private final ClusterMemoryManager clusterMemoryManager;

    @Inject
    public ClusterStatsResource(NodeSchedulerConfig nodeSchedulerConfig, InternalNodeManager nodeManager, DispatchManager dispatchManager, ClusterMemoryManager clusterMemoryManager) {
        this.isIncludeCoordinator = Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null").isIncludeCoordinator();
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.dispatchManager = Objects.requireNonNull(dispatchManager, "dispatchManager is null");
        this.clusterMemoryManager = Objects.requireNonNull(clusterMemoryManager, "clusterMemoryManager is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.WEB_UI)
    @GET
    @Produces(value={"application/json"})
    public ClusterStats getClusterStats() {
        long runningQueries = 0L;
        long blockedQueries = 0L;
        long queuedQueries = 0L;
        long activeNodes = this.nodeManager.getNodes(NodeState.ACTIVE).stream().filter(node -> this.isIncludeCoordinator || !node.isCoordinator()).count();
        long activeCoordinators = this.nodeManager.getNodes(NodeState.ACTIVE).stream().filter(node -> node.isCoordinator()).count();
        long totalAvailableProcessors = this.clusterMemoryManager.getTotalAvailableProcessors();
        long runningDrivers = 0L;
        double memoryReservation = 0.0;
        long totalInputRows = this.dispatchManager.getStats().getConsumedInputRows().getTotalCount();
        long totalInputBytes = this.dispatchManager.getStats().getConsumedInputBytes().getTotalCount();
        long totalCpuTimeSecs = this.dispatchManager.getStats().getConsumedCpuTimeSecs().getTotalCount();
        for (BasicQueryInfo query : this.dispatchManager.getQueries()) {
            if (query.getState() == QueryState.QUEUED) {
                ++queuedQueries;
            } else if (query.getState() == QueryState.RUNNING) {
                if (query.getQueryStats().isFullyBlocked()) {
                    ++blockedQueries;
                } else {
                    ++runningQueries;
                }
            }
            if (query.getState().isDone()) continue;
            totalInputBytes += query.getQueryStats().getRawInputDataSize().toBytes();
            totalInputRows += query.getQueryStats().getRawInputPositions();
            totalCpuTimeSecs = (long)((double)totalCpuTimeSecs + query.getQueryStats().getTotalCpuTime().getValue(TimeUnit.SECONDS));
            memoryReservation += (double)query.getQueryStats().getUserMemoryReservation().toBytes();
            runningDrivers += (long)query.getQueryStats().getRunningDrivers();
        }
        return new ClusterStats(runningQueries, blockedQueries, queuedQueries, activeCoordinators, activeNodes, runningDrivers, totalAvailableProcessors, memoryReservation, totalInputRows, totalInputBytes, totalCpuTimeSecs);
    }

    public static class ClusterStats {
        private final long runningQueries;
        private final long blockedQueries;
        private final long queuedQueries;
        private final long activeCoordinators;
        private final long activeWorkers;
        private final long runningDrivers;
        private final long totalAvailableProcessors;
        private final double reservedMemory;
        private final long totalInputRows;
        private final long totalInputBytes;
        private final long totalCpuTimeSecs;

        @JsonCreator
        public ClusterStats(@JsonProperty(value="runningQueries") long runningQueries, @JsonProperty(value="blockedQueries") long blockedQueries, @JsonProperty(value="queuedQueries") long queuedQueries, @JsonProperty(value="activeCoordinators") long activeCoordinators, @JsonProperty(value="activeWorkers") long activeWorkers, @JsonProperty(value="runningDrivers") long runningDrivers, @JsonProperty(value="totalAvailableProcessors") long totalAvailableProcessors, @JsonProperty(value="reservedMemory") double reservedMemory, @JsonProperty(value="totalInputRows") long totalInputRows, @JsonProperty(value="totalInputBytes") long totalInputBytes, @JsonProperty(value="totalCpuTimeSecs") long totalCpuTimeSecs) {
            this.runningQueries = runningQueries;
            this.blockedQueries = blockedQueries;
            this.queuedQueries = queuedQueries;
            this.activeCoordinators = activeCoordinators;
            this.activeWorkers = activeWorkers;
            this.runningDrivers = runningDrivers;
            this.totalAvailableProcessors = totalAvailableProcessors;
            this.reservedMemory = reservedMemory;
            this.totalInputRows = totalInputRows;
            this.totalInputBytes = totalInputBytes;
            this.totalCpuTimeSecs = totalCpuTimeSecs;
        }

        @JsonProperty
        public long getRunningQueries() {
            return this.runningQueries;
        }

        @JsonProperty
        public long getBlockedQueries() {
            return this.blockedQueries;
        }

        @JsonProperty
        public long getQueuedQueries() {
            return this.queuedQueries;
        }

        @JsonProperty
        public long getActiveCoordinators() {
            return this.activeCoordinators;
        }

        @JsonProperty
        public long getActiveWorkers() {
            return this.activeWorkers;
        }

        @JsonProperty
        public long getRunningDrivers() {
            return this.runningDrivers;
        }

        @JsonProperty
        public long getTotalAvailableProcessors() {
            return this.totalAvailableProcessors;
        }

        @JsonProperty
        public double getReservedMemory() {
            return this.reservedMemory;
        }

        @JsonProperty
        public long getTotalInputRows() {
            return this.totalInputRows;
        }

        @JsonProperty
        public long getTotalInputBytes() {
            return this.totalInputBytes;
        }

        @JsonProperty
        public long getTotalCpuTimeSecs() {
            return this.totalCpuTimeSecs;
        }
    }
}

