/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"http.server.authentication.enabled", "http-server.authentication.allow-forwarded-https", "dispatcher.forwarded-header"})
public class SecurityConfig {
    private static final Splitter SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private boolean insecureAuthenticationOverHttpAllowed = true;
    private List<String> authenticationTypes = ImmutableList.of((Object)"insecure");
    private Optional<String> fixedManagementUser = Optional.empty();
    private boolean fixedManagementUserForHttps;

    public boolean isInsecureAuthenticationOverHttpAllowed() {
        return this.insecureAuthenticationOverHttpAllowed;
    }

    @Config(value="http-server.authentication.allow-insecure-over-http")
    @ConfigDescription(value="Insecure authentication over HTTP (non-secure) enabled")
    public SecurityConfig setInsecureAuthenticationOverHttpAllowed(boolean insecureAuthenticationOverHttpAllowed) {
        this.insecureAuthenticationOverHttpAllowed = insecureAuthenticationOverHttpAllowed;
        return this;
    }

    @NotNull
    @NotEmpty(message="http-server.authentication.type cannot be empty")
    public @NotNull @NotEmpty(message="http-server.authentication.type cannot be empty") List<String> getAuthenticationTypes() {
        return this.authenticationTypes;
    }

    public SecurityConfig setAuthenticationTypes(List<String> authenticationTypes) {
        this.authenticationTypes = ImmutableList.copyOf(authenticationTypes);
        return this;
    }

    @Config(value="http-server.authentication.type")
    @ConfigDescription(value="Ordered list of authentication types")
    public SecurityConfig setAuthenticationTypes(String types) {
        this.authenticationTypes = Optional.ofNullable(types).map(arg_0 -> ((Splitter)SPLITTER).splitToList(arg_0)).orElse(null);
        return this;
    }

    public Optional<String> getFixedManagementUser() {
        return this.fixedManagementUser;
    }

    @Config(value="management.user")
    @ConfigDescription(value="Optional fixed user for all requests to management endpoints")
    public SecurityConfig setFixedManagementUser(String fixedManagementUser) {
        this.fixedManagementUser = Optional.ofNullable(fixedManagementUser);
        return this;
    }

    public boolean isFixedManagementUserForHttps() {
        return this.fixedManagementUserForHttps;
    }

    @Config(value="management.user.https-enabled")
    @ConfigDescription(value="Use fixed management user for secure HTTPS requests")
    public SecurityConfig setFixedManagementUserForHttps(boolean fixedManagementUserForHttps) {
        this.fixedManagementUserForHttps = fixedManagementUserForHttps;
        return this;
    }
}

