/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.security;

import com.google.common.collect.ImmutableList;
import io.prestosql.server.security.AnnotatedResourceAccessTypeLoader;
import io.prestosql.server.security.ResourceAccessTypeLoader;
import io.prestosql.server.security.ResourceSecurity;
import io.prestosql.server.security.ResourceSecurityBinder;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.container.ResourceInfo;

public class ResourceAccessType {
    private final List<ResourceAccessTypeLoader> resourceAccessTypeLoaders;

    @Inject
    public ResourceAccessType(ResourceSecurityBinder.StaticResourceAccessTypeLoader staticResourceAccessTypeLoader) {
        this.resourceAccessTypeLoaders = ImmutableList.builder().add((Object)staticResourceAccessTypeLoader).add((Object)new AnnotatedResourceAccessTypeLoader()).build();
    }

    public ResourceSecurity.AccessType getAccessType(ResourceInfo resourceInfo) {
        for (ResourceAccessTypeLoader resourceAccessTypeLoader : this.resourceAccessTypeLoaders) {
            Optional<ResourceSecurity.AccessType> accessType = resourceAccessTypeLoader.getAccessType(resourceInfo.getResourceMethod());
            if (accessType.isPresent()) {
                return accessType.get();
            }
            accessType = resourceAccessTypeLoader.getAccessType(resourceInfo.getResourceClass());
            if (accessType.isPresent()) {
                ResourceAccessType.verifyNotPrestoResource(resourceInfo);
                return accessType.get();
            }
            if (resourceInfo.getResourceClass().getDeclaringClass() == null || !(accessType = resourceAccessTypeLoader.getAccessType(resourceInfo.getResourceClass().getDeclaringClass())).isPresent()) continue;
            ResourceAccessType.verifyNotPrestoResource(resourceInfo);
            return accessType.get();
        }
        ResourceAccessType.verifyNotPrestoResource(resourceInfo);
        return ResourceSecurity.AccessType.MANAGEMENT_READ;
    }

    private static void verifyNotPrestoResource(ResourceInfo resourceInfo) {
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceMethod != null && resourceMethod.getDeclaringClass().getPackageName().startsWith("io.prestosql.")) {
            throw new IllegalArgumentException("Presto resource is not annotated with @" + ResourceSecurity.class.getSimpleName() + ": " + resourceInfo.getResourceMethod());
        }
    }
}

