/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server.protocol;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.prestosql.Session;
import io.prestosql.client.ClientCapabilities;
import io.prestosql.client.Column;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.Page;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.SqlTimestamp;
import io.prestosql.spi.type.SqlTimestampWithTimeZone;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampWithTimeZoneType;
import io.prestosql.spi.type.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class QueryResultRows
extends AbstractIterator<List<Object>>
implements Iterable<List<Object>> {
    private final ConnectorSession session;
    private final Optional<List<ColumnAndType>> columns;
    private final Deque<Page> pages;
    private final Optional<Consumer<Throwable>> exceptionConsumer;
    private final long totalRows;
    private final boolean supportsParametricDateTime;
    private Page currentPage;
    private int rowPosition = -1;
    private int inPageIndex = -1;

    private QueryResultRows(Session session, Optional<List<ColumnAndType>> columns, List<Page> pages, Consumer<Throwable> exceptionConsumer) {
        this.session = Objects.requireNonNull(session, "session is null").toConnectorSession();
        this.columns = Objects.requireNonNull(columns, "columns is null");
        this.pages = new ArrayDeque<Page>((Collection)Objects.requireNonNull(pages, "pages is null"));
        this.exceptionConsumer = Optional.ofNullable(exceptionConsumer);
        this.totalRows = QueryResultRows.countRows(pages);
        this.currentPage = this.pages.pollFirst();
        this.supportsParametricDateTime = session.getClientCapabilities().contains(ClientCapabilities.PARAMETRIC_DATETIME.toString());
        Verify.verify((this.totalRows == 0L || this.totalRows > 0L && columns.isPresent() ? 1 : 0) != 0, (String)"data present without columns and types", (Object[])new Object[0]);
    }

    public boolean isEmpty() {
        return this.totalRows == 0L;
    }

    public Optional<List<Column>> getColumns() {
        return this.columns.map(columns -> (List)columns.stream().map(ColumnAndType::getColumn).collect(ImmutableList.toImmutableList()));
    }

    @VisibleForTesting
    public long getTotalRowsCount() {
        return this.totalRows;
    }

    public Optional<Long> getUpdateCount() {
        if (this.totalRows != 1L || this.columns.isEmpty()) {
            return Optional.empty();
        }
        List<ColumnAndType> columns = this.columns.get();
        if (columns.size() != 1 || !columns.get(0).getType().equals(BigintType.BIGINT)) {
            return Optional.empty();
        }
        Verify.verifyNotNull((Object)this.currentPage, (String)"currentPage is null", (Object[])new Object[0]);
        Number value = (Number)columns.get(0).getType().getObjectValue(this.session, this.currentPage.getBlock(0), 0);
        return Optional.ofNullable(value).map(Number::longValue);
    }

    protected List<Object> computeNext() {
        Optional<List<Object>> row;
        do {
            if (this.currentPage == null) {
                return (List)this.endOfData();
            }
            ++this.inPageIndex;
            if (this.inPageIndex >= this.currentPage.getPositionCount()) {
                this.currentPage = this.pages.pollFirst();
                if (this.currentPage == null) {
                    return (List)this.endOfData();
                }
                this.inPageIndex = 0;
            }
            ++this.rowPosition;
        } while ((row = this.getRowValues()).isEmpty());
        return row.get();
    }

    private Optional<List<Object>> getRowValues() {
        List<ColumnAndType> columns = this.columns.orElseThrow();
        ArrayList<Object> row = new ArrayList<Object>(columns.size());
        for (int channel = 0; channel < this.currentPage.getChannelCount(); ++channel) {
            ColumnAndType column = columns.get(channel);
            Type type = column.getType();
            Block block = this.currentPage.getBlock(channel);
            try {
                if (type instanceof TimestampType && !this.supportsParametricDateTime) {
                    row.add(channel, ((SqlTimestamp)type.getObjectValue(this.session, block, this.inPageIndex)).roundTo(3));
                    continue;
                }
                if (type instanceof TimestampWithTimeZoneType && !this.supportsParametricDateTime) {
                    row.add(channel, ((SqlTimestampWithTimeZone)type.getObjectValue(this.session, block, this.inPageIndex)).roundTo(3));
                    continue;
                }
                row.add(channel, type.getObjectValue(this.session, block, this.inPageIndex));
                continue;
            }
            catch (Throwable throwable) {
                this.propagateException(this.rowPosition, column, throwable);
                return Optional.empty();
            }
        }
        return Optional.of(Collections.unmodifiableList(row));
    }

    private void propagateException(int row, ColumnAndType column, Throwable cause) {
        String message = String.format("Could not serialize column '%s' of type '%s' at position %d:%d", column.getColumn().getName(), column.getType(), row + 1, column.getPosition() + 1);
        this.exceptionConsumer.ifPresent(consumer -> consumer.accept(new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERIALIZATION_ERROR, message, cause)));
    }

    @Override
    public Iterator<List<Object>> iterator() {
        return this;
    }

    private static long countRows(List<Page> pages) {
        return pages.stream().map(Page::getPositionCount).map(Integer::longValue).reduce(Long::sum).orElse(0L);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).add("totalRowsCount", this.getTotalRowsCount()).add("pagesCount", this.pages.size()).toString();
    }

    public static QueryResultRows empty(Session session) {
        return new QueryResultRows(session, Optional.empty(), (List<Page>)ImmutableList.of(), null);
    }

    public static Builder queryResultRowsBuilder(Session session) {
        return new Builder(session);
    }

    private static class ColumnAndType {
        private final int position;
        private final Column column;
        private final Type type;

        private ColumnAndType(int position, Column column, Type type) {
            this.position = position;
            this.column = column;
            this.type = type;
        }

        public Column getColumn() {
            return this.column;
        }

        public Type getType() {
            return this.type;
        }

        public int getPosition() {
            return this.position;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("column", (Object)this.column).add("type", (Object)this.type).add("position", this.position).toString();
        }
    }

    public static class Builder {
        private final Session session;
        private ImmutableList.Builder<Page> pages = ImmutableList.builder();
        private Optional<List<ColumnAndType>> columns = Optional.empty();
        private Consumer<Throwable> exceptionConsumer;

        public Builder(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public Builder addPage(Page page) {
            this.pages.add((Object)page);
            return this;
        }

        public Builder addPages(List<Page> page) {
            this.pages.addAll(page);
            return this;
        }

        public Builder withColumnsAndTypes(@Nullable List<Column> columns, @Nullable List<Type> types) {
            if (columns != null || types != null) {
                this.columns = Optional.of(Builder.combine(columns, types));
            }
            return this;
        }

        public Builder withSingleBooleanValue(Column column, boolean value) {
            BlockBuilder blockBuilder = BooleanType.BOOLEAN.createBlockBuilder(null, 1);
            BooleanType.BOOLEAN.writeBoolean(blockBuilder, value);
            this.pages = ImmutableList.builder().add((Object)new Page(new Block[]{blockBuilder.build()}));
            this.columns = Optional.of(Builder.combine((List<Column>)ImmutableList.of((Object)column), (List<Type>)ImmutableList.of((Object)BooleanType.BOOLEAN)));
            return this;
        }

        public Builder withExceptionConsumer(Consumer<Throwable> exceptionConsumer) {
            this.exceptionConsumer = exceptionConsumer;
            return this;
        }

        public QueryResultRows build() {
            return new QueryResultRows(this.session, this.columns, (List<Page>)this.pages.build(), this.exceptionConsumer);
        }

        private static List<ColumnAndType> combine(@Nullable List<Column> columns, @Nullable List<Type> types) {
            Preconditions.checkArgument((columns != null && types != null ? 1 : 0) != 0, (Object)"columns and types must be present at the same time");
            Preconditions.checkArgument((columns.size() == types.size() ? 1 : 0) != 0, (Object)"columns and types size mismatch");
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < columns.size(); ++i) {
                builder.add((Object)new ColumnAndType(i, columns.get(i), types.get(i)));
            }
            return builder.build();
        }
    }
}

