/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.prestosql.server.security.ResourceSecurity;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/v1/thread")
public class ThreadResource {
    @ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_READ)
    @GET
    @Produces(value={"application/json"})
    public List<Info> getThreadInfo() {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        List threads = Arrays.stream(mbean.getThreadInfo(mbean.getAllThreadIds(), Integer.MAX_VALUE)).filter(Objects::nonNull).map(ThreadResource::toInfo).collect(Collectors.toUnmodifiableList());
        return Ordering.from(Info.byName()).sortedCopy(threads);
    }

    private static Info toInfo(ThreadInfo info) {
        return new Info(info.getThreadId(), info.getThreadName(), info.getThreadState().name(), info.getLockOwnerId() == -1L ? null : Long.valueOf(info.getLockOwnerId()), ThreadResource.toStackTrace(info.getStackTrace()));
    }

    private static List<StackLine> toStackTrace(StackTraceElement[] stackTrace) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StackTraceElement item : stackTrace) {
            builder.add((Object)new StackLine(item.getFileName(), item.getLineNumber(), item.getClassName(), item.getMethodName()));
        }
        return builder.build();
    }

    public static class StackLine {
        private final String file;
        private final int line;
        private final String className;
        private final String method;

        @JsonCreator
        public StackLine(@JsonProperty(value="file") String file, @JsonProperty(value="line") int line, @JsonProperty(value="className") String className, @JsonProperty(value="method") String method) {
            this.file = file;
            this.line = line;
            this.className = className;
            this.method = method;
        }

        @JsonProperty
        public String getFile() {
            return this.file;
        }

        @JsonProperty
        public int getLine() {
            return this.line;
        }

        @JsonProperty
        public String getClassName() {
            return this.className;
        }

        @JsonProperty
        public String getMethod() {
            return this.method;
        }
    }

    public static class Info {
        private final long id;
        private final String name;
        private final String state;
        private final Long lockOwnerId;
        private final List<StackLine> stackTrace;

        @JsonCreator
        public Info(@JsonProperty(value="id") long id, @JsonProperty(value="name") String name, @JsonProperty(value="state") String state, @JsonProperty(value="lockOwnerId") Long lockOwnerId, @JsonProperty(value="stackTrace") List<StackLine> stackTrace) {
            this.id = id;
            this.name = name;
            this.state = state;
            this.lockOwnerId = lockOwnerId;
            this.stackTrace = stackTrace;
        }

        @JsonProperty
        public long getId() {
            return this.id;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public String getState() {
            return this.state;
        }

        @JsonProperty
        public Long getLockOwnerId() {
            return this.lockOwnerId;
        }

        @JsonProperty
        public List<StackLine> getStackTrace() {
            return this.stackTrace;
        }

        public static Comparator<Info> byName() {
            return new Comparator<Info>(){

                @Override
                public int compare(Info info, Info info2) {
                    return info.getName().compareTo(info2.getName());
                }
            };
        }
    }
}

