/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import io.prestosql.execution.AddColumnTask;
import io.prestosql.execution.CallTask;
import io.prestosql.execution.CommentTask;
import io.prestosql.execution.CommitTask;
import io.prestosql.execution.CreateRoleTask;
import io.prestosql.execution.CreateSchemaTask;
import io.prestosql.execution.CreateTableTask;
import io.prestosql.execution.CreateViewTask;
import io.prestosql.execution.DataDefinitionExecution;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.DeallocateTask;
import io.prestosql.execution.DropColumnTask;
import io.prestosql.execution.DropRoleTask;
import io.prestosql.execution.DropSchemaTask;
import io.prestosql.execution.DropTableTask;
import io.prestosql.execution.DropViewTask;
import io.prestosql.execution.GrantRolesTask;
import io.prestosql.execution.GrantTask;
import io.prestosql.execution.PrepareTask;
import io.prestosql.execution.QueryExecution;
import io.prestosql.execution.RenameColumnTask;
import io.prestosql.execution.RenameSchemaTask;
import io.prestosql.execution.RenameTableTask;
import io.prestosql.execution.RenameViewTask;
import io.prestosql.execution.ResetSessionTask;
import io.prestosql.execution.RevokeRolesTask;
import io.prestosql.execution.RevokeTask;
import io.prestosql.execution.RollbackTask;
import io.prestosql.execution.SetPathTask;
import io.prestosql.execution.SetRoleTask;
import io.prestosql.execution.SetSchemaAuthorizationTask;
import io.prestosql.execution.SetSessionTask;
import io.prestosql.execution.SqlQueryExecution;
import io.prestosql.execution.StartTransactionTask;
import io.prestosql.execution.UseTask;
import io.prestosql.spi.resourcegroups.QueryType;
import io.prestosql.sql.tree.AddColumn;
import io.prestosql.sql.tree.Call;
import io.prestosql.sql.tree.Comment;
import io.prestosql.sql.tree.Commit;
import io.prestosql.sql.tree.CreateRole;
import io.prestosql.sql.tree.CreateSchema;
import io.prestosql.sql.tree.CreateTable;
import io.prestosql.sql.tree.CreateView;
import io.prestosql.sql.tree.Deallocate;
import io.prestosql.sql.tree.DropColumn;
import io.prestosql.sql.tree.DropRole;
import io.prestosql.sql.tree.DropSchema;
import io.prestosql.sql.tree.DropTable;
import io.prestosql.sql.tree.DropView;
import io.prestosql.sql.tree.Grant;
import io.prestosql.sql.tree.GrantRoles;
import io.prestosql.sql.tree.Prepare;
import io.prestosql.sql.tree.RenameColumn;
import io.prestosql.sql.tree.RenameSchema;
import io.prestosql.sql.tree.RenameTable;
import io.prestosql.sql.tree.RenameView;
import io.prestosql.sql.tree.ResetSession;
import io.prestosql.sql.tree.Revoke;
import io.prestosql.sql.tree.RevokeRoles;
import io.prestosql.sql.tree.Rollback;
import io.prestosql.sql.tree.SetPath;
import io.prestosql.sql.tree.SetRole;
import io.prestosql.sql.tree.SetSchemaAuthorization;
import io.prestosql.sql.tree.SetSession;
import io.prestosql.sql.tree.StartTransaction;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.Use;
import io.prestosql.util.StatementUtils;
import java.util.Map;

public class QueryExecutionFactoryModule
implements Module {
    public void configure(Binder binder) {
        MapBinder executionBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<QueryExecution.QueryExecutionFactory<?>>(){});
        binder.bind(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON);
        StatementUtils.getAllQueryTypes().entrySet().stream().filter(entry -> entry.getValue() != QueryType.DATA_DEFINITION).map(Map.Entry::getKey).forEach(statement -> executionBinder.addBinding(statement).to(SqlQueryExecution.SqlQueryExecutionFactory.class).in(Scopes.SINGLETON));
        binder.bind(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, AddColumn.class, AddColumnTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Call.class, CallTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Comment.class, CommentTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Commit.class, CommitTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateRole.class, CreateRoleTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateSchema.class, CreateSchemaTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateTable.class, CreateTableTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, CreateView.class, CreateViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Deallocate.class, DeallocateTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropColumn.class, DropColumnTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropRole.class, DropRoleTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropSchema.class, DropSchemaTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropTable.class, DropTableTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, DropView.class, DropViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Grant.class, GrantTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, GrantRoles.class, GrantRolesTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Prepare.class, PrepareTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameColumn.class, RenameColumnTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameSchema.class, RenameSchemaTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameTable.class, RenameTableTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RenameView.class, RenameViewTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, ResetSession.class, ResetSessionTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Revoke.class, RevokeTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, RevokeRoles.class, RevokeRolesTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Rollback.class, RollbackTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetPath.class, SetPathTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetRole.class, SetRoleTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetSchemaAuthorization.class, SetSchemaAuthorizationTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, SetSession.class, SetSessionTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, StartTransaction.class, StartTransactionTask.class);
        QueryExecutionFactoryModule.bindDataDefinitionTask(binder, executionBinder, Use.class, UseTask.class);
    }

    private static <T extends Statement> void bindDataDefinitionTask(Binder binder, MapBinder<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionBinder, Class<T> statement, Class<? extends DataDefinitionTask<T>> task) {
        Preconditions.checkArgument((StatementUtils.getAllQueryTypes().get(statement) == QueryType.DATA_DEFINITION ? 1 : 0) != 0);
        MapBinder taskBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends Statement>>(){}, (TypeLiteral)new TypeLiteral<DataDefinitionTask<?>>(){});
        taskBinder.addBinding(statement).to(task).in(Scopes.SINGLETON);
        executionBinder.addBinding(statement).to(DataDefinitionExecution.DataDefinitionExecutionFactory.class).in(Scopes.SINGLETON);
    }
}

