/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.airlift.units.Duration;
import io.prestosql.execution.SqlQueryExecution;
import io.prestosql.execution.StageState;
import io.prestosql.execution.TaskManagerConfig;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.DynamicFilters;
import io.prestosql.sql.planner.Symbol;
import io.prestosql.sql.planner.optimizations.PlanNodeSearcher;
import io.prestosql.sql.planner.plan.DynamicFilterId;
import io.prestosql.sql.planner.plan.JoinNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class DynamicFilterService {
    private final Map<SourceDescriptor, Domain> dynamicFilterSummaries = new ConcurrentHashMap<SourceDescriptor, Domain>();
    private final Duration statusRefreshMaxWait;
    @GuardedBy(value="this")
    private final Map<QueryId, Supplier<List<StageDynamicFilters>>> queries = new HashMap<QueryId, Supplier<List<StageDynamicFilters>>>();
    @GuardedBy(value="this")
    private final Map<QueryId, Set<SourceDescriptor>> queryDynamicFilters = new HashMap<QueryId, Set<SourceDescriptor>>();
    private final ScheduledExecutorService collectDynamicFiltersExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"DynamicFilterService"));

    @Inject
    public DynamicFilterService(TaskManagerConfig taskConfig) {
        this.statusRefreshMaxWait = Objects.requireNonNull(taskConfig, "taskConfig is null").getStatusRefreshMaxWait();
    }

    @PostConstruct
    public void start() {
        this.collectDynamicFiltersExecutor.scheduleWithFixedDelay(this::collectDynamicFilters, 0L, this.statusRefreshMaxWait.toMillis(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void stop() {
        this.collectDynamicFiltersExecutor.shutdownNow();
    }

    public void registerQuery(SqlQueryExecution sqlQueryExecution) {
        Set dynamicFilters = (Set)PlanNodeSearcher.searchFrom(sqlQueryExecution.getQueryPlan().getRoot()).where(JoinNode.class::isInstance).findAll().stream().flatMap(node -> node.getDynamicFilters().keySet().stream()).map(dynamicFilter -> SourceDescriptor.of(sqlQueryExecution.getQueryId(), dynamicFilter)).collect(ImmutableSet.toImmutableSet());
        if (!dynamicFilters.isEmpty()) {
            this.registerQuery(sqlQueryExecution.getQueryId(), sqlQueryExecution::getStageDynamicFilters, dynamicFilters);
        }
    }

    @VisibleForTesting
    synchronized void registerQuery(QueryId queryId, Supplier<List<StageDynamicFilters>> stageDynamicFiltersSupplier, Set<SourceDescriptor> dynamicFilters) {
        this.queries.putIfAbsent(queryId, stageDynamicFiltersSupplier);
        this.queryDynamicFilters.put(queryId, dynamicFilters);
    }

    public synchronized void removeQuery(QueryId queryId) {
        this.dynamicFilterSummaries.keySet().removeIf(sourceDescriptor -> sourceDescriptor.getQueryId().equals((Object)queryId));
        this.queries.remove(queryId);
        this.queryDynamicFilters.remove(queryId);
    }

    @VisibleForTesting
    public void collectDynamicFilters() {
        for (Map.Entry<QueryId, Supplier<List<StageDynamicFilters>>> entry : this.getQueries().entrySet()) {
            QueryId queryId = entry.getKey();
            ImmutableMap.Builder newDynamicFiltersBuilder = ImmutableMap.builder();
            for (StageDynamicFilters stageDynamicFilters : entry.getValue().get()) {
                StageState stageState = stageDynamicFilters.getStageState();
                if (stageState.canScheduleMoreTasks()) continue;
                stageDynamicFilters.getTaskDynamicFilters().stream().flatMap(taskDomains -> taskDomains.entrySet().stream()).filter(domain -> !this.dynamicFilterSummaries.containsKey(SourceDescriptor.of(queryId, (DynamicFilterId)domain.getKey()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, ImmutableList.toImmutableList()))).entrySet().stream().filter(stageDomains -> ((ImmutableList)stageDomains.getValue()).size() == stageDynamicFilters.getNumberOfTasks()).forEach(stageDomains -> newDynamicFiltersBuilder.put((Object)SourceDescriptor.of(queryId, (DynamicFilterId)stageDomains.getKey()), (Object)Domain.union((List)((List)stageDomains.getValue()))));
            }
            ImmutableMap newDynamicFilters = newDynamicFiltersBuilder.build();
            if (newDynamicFilters.isEmpty()) continue;
            this.addDynamicFilters(queryId, (Map<SourceDescriptor, Domain>)newDynamicFilters);
        }
    }

    public Supplier<TupleDomain<ColumnHandle>> createDynamicFilterSupplier(QueryId queryId, List<DynamicFilters.Descriptor> dynamicFilters, Map<Symbol, ColumnHandle> columnHandles) {
        Map<DynamicFilterId, ColumnHandle> sourceColumnHandles = DynamicFilterService.extractSourceColumnHandles(dynamicFilters, columnHandles);
        return () -> dynamicFilters.stream().map(filter -> this.getSummary(queryId, filter.getId()).map(summary -> DynamicFilterService.translateSummaryToTupleDomain(filter.getId(), summary, sourceColumnHandles))).filter(Optional::isPresent).map(Optional::get).reduce(TupleDomain.all(), TupleDomain::intersect);
    }

    @VisibleForTesting
    Optional<Domain> getSummary(QueryId queryId, DynamicFilterId filterId) {
        return Optional.ofNullable(this.dynamicFilterSummaries.get(SourceDescriptor.of(queryId, filterId)));
    }

    private synchronized Map<QueryId, Supplier<List<StageDynamicFilters>>> getQueries() {
        return ImmutableMap.copyOf(this.queries);
    }

    private synchronized void addDynamicFilters(QueryId queryId, Map<SourceDescriptor, Domain> dynamicFilters) {
        if (!this.queries.containsKey(queryId)) {
            return;
        }
        this.dynamicFilterSummaries.putAll(dynamicFilters);
        if (this.dynamicFilterSummaries.keySet().containsAll((Collection)this.queryDynamicFilters.get(queryId))) {
            this.queries.remove(queryId);
        }
    }

    private static TupleDomain<ColumnHandle> translateSummaryToTupleDomain(DynamicFilterId filterId, Domain summary, Map<DynamicFilterId, ColumnHandle> sourceColumnHandles) {
        ColumnHandle sourceColumnHandle = Objects.requireNonNull(sourceColumnHandles.get(filterId), () -> String.format("Source column handle for dynamic filter %s is null", filterId));
        return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)sourceColumnHandle, (Object)summary));
    }

    private static Map<DynamicFilterId, ColumnHandle> extractSourceColumnHandles(List<DynamicFilters.Descriptor> dynamicFilters, Map<Symbol, ColumnHandle> columnHandles) {
        return (Map)dynamicFilters.stream().collect(ImmutableMap.toImmutableMap(DynamicFilters.Descriptor::getId, descriptor -> (ColumnHandle)columnHandles.get(Symbol.from(descriptor.getInput()))));
    }

    @Immutable
    @VisibleForTesting
    static class SourceDescriptor {
        private final QueryId queryId;
        private final DynamicFilterId filterId;

        public static SourceDescriptor of(QueryId queryId, DynamicFilterId filterId) {
            return new SourceDescriptor(queryId, filterId);
        }

        private SourceDescriptor(QueryId queryId, DynamicFilterId filterId) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.filterId = Objects.requireNonNull(filterId, "filterId is null");
        }

        public QueryId getQueryId() {
            return this.queryId;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SourceDescriptor sourceDescriptor = (SourceDescriptor)other;
            return Objects.equals(this.queryId, sourceDescriptor.queryId) && Objects.equals(this.filterId, sourceDescriptor.filterId);
        }

        public int hashCode() {
            return Objects.hash(this.queryId, this.filterId);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("filterId", (Object)this.filterId).toString();
        }
    }

    public static class StageDynamicFilters {
        private final StageState stageState;
        private final int numberOfTasks;
        private final List<Map<DynamicFilterId, Domain>> taskDynamicFilters;

        public StageDynamicFilters(StageState stageState, int numberOfTasks, List<Map<DynamicFilterId, Domain>> taskDynamicFilters) {
            this.stageState = Objects.requireNonNull(stageState, "stageState is null");
            this.numberOfTasks = numberOfTasks;
            this.taskDynamicFilters = ImmutableList.copyOf((Collection)Objects.requireNonNull(taskDynamicFilters, "taskDynamicFilters is null"));
        }

        private StageState getStageState() {
            return this.stageState;
        }

        private int getNumberOfTasks() {
            return this.numberOfTasks;
        }

        private List<Map<DynamicFilterId, Domain>> getTaskDynamicFilters() {
            return this.taskDynamicFilters;
        }
    }
}

