/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.window;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.RankingWindowFunction;
import io.prestosql.spi.function.WindowFunctionSignature;
import io.prestosql.spi.type.BigintType;
import io.prestosql.util.Failures;
import java.util.List;

@WindowFunctionSignature(name="ntile", returnType="bigint", argumentTypes={"bigint"})
public class NTileFunction
extends RankingWindowFunction {
    private final int valueChannel;
    private int rowCount;

    public NTileFunction(List<Integer> argumentChannels) {
        this.valueChannel = argumentChannels.get(0);
    }

    public void reset() {
        this.rowCount = this.windowIndex.size();
    }

    public void processRow(BlockBuilder output, boolean newPeerGroup, int peerGroupCount, int currentPosition) {
        if (this.windowIndex.isNull(this.valueChannel, currentPosition)) {
            output.appendNull();
        } else {
            long buckets = this.windowIndex.getLong(this.valueChannel, currentPosition);
            Failures.checkCondition(buckets > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Buckets must be greater than 0", new Object[0]);
            BigintType.BIGINT.writeLong(output, this.bucket(buckets, currentPosition) + 1L);
        }
    }

    private long bucket(long buckets, int currentRow) {
        if ((long)this.rowCount < buckets) {
            return currentRow;
        }
        long rowsPerBucket = (long)this.rowCount / buckets;
        long remainderRows = (long)this.rowCount % buckets;
        if ((long)currentRow < (rowsPerBucket + 1L) * remainderRows) {
            return (long)currentRow / (rowsPerBucket + 1L);
        }
        return ((long)currentRow - remainderRows) / rowsPerBucket;
    }
}

