/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToTimeWithTimezoneCast {
    private TimestampWithTimeZoneToTimeWithTimezoneCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time with time zone")
    public static long cast(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return TimestampWithTimeZoneToTimeWithTimezoneCast.convert(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis), DateTimeEncoding.unpackZoneKey((long)packedEpochMillis));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time with time zone")
    public static long cast(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return TimestampWithTimeZoneToTimeWithTimezoneCast.convert(Timestamps.roundToEpochMillis(timestamp), TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()));
    }

    private static long convert(long epochMillis, TimeZoneKey timeZoneKey) {
        int millis = DateTimeZoneIndex.getChronology(timeZoneKey).millisOfDay().get(epochMillis);
        millis -= DateTimeZoneIndex.getChronology(timeZoneKey).getZone().getOffset((long)millis);
        return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)timeZoneKey);
    }
}

