/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampWithTimeZoneToTimeCast {
    private TimestampWithTimeZoneToTimeCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return TimestampWithTimeZoneToTimeCast.convert(session, DateTimeZoneIndex.getChronology(DateTimeEncoding.unpackZoneKey((long)packedEpochMillis)), DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="time")
    public static long cast(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return TimestampWithTimeZoneToTimeCast.convert(session, DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())), Timestamps.roundToEpochMillis(timestamp));
    }

    private static long convert(ConnectorSession session, ISOChronology chronology, long epochMillis) {
        if (session.isLegacyTimestamp()) {
            int millis = chronology.millisOfDay().get(epochMillis) - chronology.getZone().getOffset(epochMillis);
            millis = (int)((long)millis - DateTimeFunctions.valueToSessionTimeZoneOffsetDiff(epochMillis, DateTimeZoneIndex.getDateTimeZone(session.getTimeZoneKey())));
            return millis;
        }
        long millis = chronology.getZone().convertUTCToLocal(epochMillis);
        return ISOChronology.getInstanceUTC().millisOfDay().get(millis);
    }
}

