/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.DateTimeZoneIndex;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

@ScalarOperator(value=OperatorType.CAST)
@ScalarFunction(value="date")
public final class TimestampWithTimeZoneToDateCast {
    private TimestampWithTimeZoneToDateCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long cast(@SqlType(value="timestamp(p) with time zone") long timestamp) {
        long epochMillis = DateTimeEncoding.unpackMillisUtc((long)timestamp);
        TimeZoneKey zoneKey = DateTimeEncoding.unpackZoneKey((long)timestamp);
        return TimestampWithTimeZoneToDateCast.toDate(epochMillis, zoneKey);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long cast(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return TimestampWithTimeZoneToDateCast.toDate(timestamp.getEpochMillis(), TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey()));
    }

    private static long toDate(long epochMillis, TimeZoneKey zoneKey) {
        ISOChronology chronology = DateTimeZoneIndex.getChronology(zoneKey);
        long date = chronology.dayOfYear().roundFloor(epochMillis);
        long millis = date + (long)chronology.getZone().getOffset(date);
        return TimeUnit.MILLISECONDS.toDays(millis);
    }
}

