/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeToTimestampWithTimeZoneCast {
    private TimeToTimestampWithTimeZoneCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="time") long time) {
        long epochMillis = TimeToTimestampWithTimeZoneCast.convert(session, Timestamps.round(time, (int)(3L - precision)));
        return DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)session.getTimeZoneKey());
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone cast(ConnectorSession session, @SqlType(value="time") long time) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)TimeToTimestampWithTimeZoneCast.convert(session, time), (int)0, (TimeZoneKey)session.getTimeZoneKey());
    }

    private static long convert(ConnectorSession session, long time) {
        if (session.isLegacyTimestamp()) {
            return time;
        }
        return DateTimeZoneIndex.getChronology(session.getTimeZoneKey()).getZone().convertLocalToUTC(time, false);
    }
}

