/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.util.Failures;

@ScalarFunction(value="at_timezone", hidden=true)
public class AtTimeZoneWithOffset {
    private AtTimeZoneWithOffset() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long atTimeZone(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="interval day to second") long zoneOffset) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)AtTimeZoneWithOffset.getZoneOffsetMinutes(zoneOffset)));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone atTimeZone(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="interval day to second") long zoneOffset) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)timestamp.getEpochMillis(), (int)timestamp.getPicosOfMilli(), (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)AtTimeZoneWithOffset.getZoneOffsetMinutes(zoneOffset)));
    }

    private static long getZoneOffsetMinutes(long interval) {
        Failures.checkCondition(interval % 60000L == 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Invalid time zone offset interval: interval contains seconds", new Object[0]);
        return interval / 60000L;
    }
}

