/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;

@ScalarFunction(value="at_timezone")
public class AtTimeZone {
    private AtTimeZone() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long atTimeZone(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis, @SqlType(value="varchar(x)") Slice zoneId) {
        return DateTimeEncoding.packDateTimeWithZone((long)DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis), (String)zoneId.toStringUtf8());
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone atTimeZone(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp, @SqlType(value="varchar(x)") Slice zoneId) {
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)timestamp.getEpochMillis(), (int)timestamp.getPicosOfMilli(), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8()));
    }
}

