/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.LongTimestampWithTimeZone;
import io.prestosql.spi.type.TimeZoneKey;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.DateTimeZone;

@ScalarFunction(value="with_timezone")
public class WithTimeZone {
    private WithTimeZone() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static long shortPrecision(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="varchar(x)") Slice zoneId) {
        Verify.verify((precision <= 3L ? 1 : 0) != 0, (String)"Expected precision <= 3", (Object[])new Object[0]);
        TimeZoneKey toTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8());
        DateTimeZone fromDateTimeZone = session.isLegacyTimestamp() ? DateTimeZoneIndex.getDateTimeZone(session.getTimeZoneKey()) : DateTimeZone.UTC;
        DateTimeZone toDateTimeZone = DateTimeZoneIndex.getDateTimeZone(toTimeZoneKey);
        return DateTimeEncoding.packDateTimeWithZone((long)fromDateTimeZone.getMillisKeepLocal(toDateTimeZone, timestamp), (TimeZoneKey)toTimeZoneKey);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone mediumPrecision(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="varchar(x)") Slice zoneId) {
        Verify.verify((precision > 3L && precision <= 6L ? 1 : 0) != 0, (String)"Expected precision in [4, 6]", (Object[])new Object[0]);
        return WithTimeZone.toLong(timestamp, 0, zoneId, session);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p) with time zone")
    public static LongTimestampWithTimeZone largePrecision(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="varchar(x)") Slice zoneId) {
        Verify.verify((precision > 6L ? 1 : 0) != 0, (String)"Expected precision > 6", (Object[])new Object[0]);
        return WithTimeZone.toLong(timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), zoneId, session);
    }

    private static LongTimestampWithTimeZone toLong(long epochMicros, int picosOfMicro, Slice zoneId, ConnectorSession session) {
        TimeZoneKey toTimeZoneKey = TimeZoneKey.getTimeZoneKey((String)zoneId.toStringUtf8());
        DateTimeZone fromDateTimeZone = session.isLegacyTimestamp() ? DateTimeZoneIndex.getDateTimeZone(session.getTimeZoneKey()) : DateTimeZone.UTC;
        DateTimeZone toDateTimeZone = DateTimeZoneIndex.getDateTimeZone(toTimeZoneKey);
        long epochMillis = Timestamps.scaleEpochMicrosToMillis(epochMicros);
        epochMillis = fromDateTimeZone.getMillisKeepLocal(toDateTimeZone, epochMillis);
        int picosOfMilli = Timestamps.getMicrosOfMilli(epochMicros) * 1000000 + picosOfMicro;
        return LongTimestampWithTimeZone.fromEpochMillisAndFraction((long)epochMillis, (int)picosOfMilli, (TimeZoneKey)toTimeZoneKey);
    }
}

