/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Constraint;
import io.prestosql.type.Timestamps;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarFunction(value="to_iso8601")
public final class ToIso8601 {
    private static final DateTimeFormatter ISO8601_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss");
    private static final String RESULT_LENGTH = "1 + 6 + 15 + min(p, 1) + p";

    private ToIso8601() {
    }

    @LiteralParameters(value={"p", "n"})
    @SqlType(value="varchar(n)")
    @Constraint(variable="n", expression="1 + 6 + 15 + min(p, 1) + p")
    public static Slice toIso8601(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        long epochMicros = timestamp;
        if (precision <= 3L) {
            epochMicros = Timestamps.scaleEpochMillisToMicros(timestamp);
        }
        ZoneId zoneId = ZoneOffset.UTC;
        if (session.isLegacyTimestamp()) {
            zoneId = session.getTimeZoneKey().getZoneId();
        }
        return Slices.utf8Slice((String)Timestamps.formatTimestamp((int)precision, epochMicros, 0, zoneId, ISO8601_FORMATTER));
    }

    @LiteralParameters(value={"p", "n"})
    @SqlType(value="varchar(n)")
    @Constraint(variable="n", expression="1 + 6 + 15 + min(p, 1) + p")
    public static Slice toIso8601(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        ZoneId zoneId = ZoneOffset.UTC;
        if (session.isLegacyTimestamp()) {
            zoneId = session.getTimeZoneKey().getZoneId();
        }
        return Slices.utf8Slice((String)Timestamps.formatTimestamp((int)precision, timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), zoneId, ISO8601_FORMATTER));
    }
}

