/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToVarcharCast {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");

    private TimestampToVarcharCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        long epochMicros = timestamp;
        if (precision <= 3L) {
            epochMicros = Timestamps.scaleEpochMillisToMicros(timestamp);
        }
        ZoneId zoneId = ZoneOffset.UTC;
        if (session.isLegacyTimestamp()) {
            zoneId = session.getTimeZoneKey().getZoneId();
        }
        return Slices.utf8Slice((String)Timestamps.formatTimestamp((int)precision, epochMicros, 0, zoneId, TIMESTAMP_FORMATTER));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        ZoneId zoneId = ZoneOffset.UTC;
        if (session.isLegacyTimestamp()) {
            zoneId = session.getTimeZoneKey().getZoneId();
        }
        return Slices.utf8Slice((String)Timestamps.formatTimestamp((int)precision, timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), zoneId, TIMESTAMP_FORMATTER));
    }
}

