/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import com.fasterxml.jackson.core.JsonGenerator;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.JsonUtil;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@ScalarOperator(value=OperatorType.CAST)
public final class TimestampToJsonCast {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");

    private TimestampToJsonCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="json")
    public static Slice cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        long epochMicros = timestamp;
        if (precision <= 3L) {
            epochMicros = Timestamps.scaleEpochMillisToMicros(timestamp);
        }
        ZoneId zoneId = ZoneOffset.UTC;
        if (session.isLegacyTimestamp()) {
            zoneId = session.getTimeZoneKey().getZoneId();
        }
        return TimestampToJsonCast.toJson(Timestamps.formatTimestamp((int)precision, epochMicros, 0, zoneId, TIMESTAMP_FORMATTER));
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="json")
    public static Slice cast(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        ZoneId zoneId = ZoneOffset.UTC;
        if (session.isLegacyTimestamp()) {
            zoneId = session.getTimeZoneKey().getZoneId();
        }
        return TimestampToJsonCast.toJson(Timestamps.formatTimestamp((int)precision, timestamp.getEpochMicros(), timestamp.getPicosOfMicro(), zoneId, TIMESTAMP_FORMATTER));
    }

    private static Slice toJson(String formatted) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(formatted.length() + 2);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JsonUtil.JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(formatted);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", formatted, "json"));
        }
    }
}

