/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.operator.scalar.timestamp.TimestampOperators;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.BlockIndex;
import io.prestosql.spi.function.BlockPosition;
import io.prestosql.spi.function.IsNull;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.TimestampType;

@ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
public final class TimestampDistinctFromOperator {
    private static final TimestampType SHORT_TYPE = TimestampType.createTimestampType((int)0);
    private static final TimestampType LONG_TYPE = TimestampType.createTimestampType((int)7);

    private TimestampDistinctFromOperator() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@SqlType(value="timestamp(p)") long left, @IsNull boolean leftNull, @SqlType(value="timestamp(p)") long right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return TimestampOperators.NotEqual.notEqual(left, right);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@BlockPosition @SqlType(value="timestamp(p)", nativeContainerType=long.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="timestamp(p)", nativeContainerType=long.class) Block right, @BlockIndex int rightPosition) {
        if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
            return true;
        }
        if (left.isNull(leftPosition)) {
            return false;
        }
        return TimestampOperators.NotEqual.notEqual(SHORT_TYPE.getLong(left, leftPosition), SHORT_TYPE.getLong(right, rightPosition));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFromShort(@SqlType(value="timestamp(p)") LongTimestamp left, @IsNull boolean leftNull, @SqlType(value="timestamp(p)") LongTimestamp right, @IsNull boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        return TimestampOperators.NotEqual.notEqual(left, right);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="boolean")
    public static boolean isDistinctFromLong(@BlockPosition @SqlType(value="timestamp(p)", nativeContainerType=LongTimestamp.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="timestamp(p)", nativeContainerType=LongTimestamp.class) Block right, @BlockIndex int rightPosition) {
        if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
            return true;
        }
        if (left.isNull(leftPosition)) {
            return false;
        }
        return !LONG_TYPE.equalTo(left, leftPosition, right, rightPosition);
    }
}

