/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeToTimestampCast {
    private TimeToTimestampCast() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static long cast(@LiteralParameter(value="p") long precision, @SqlType(value="time") long time) {
        if (precision > 3L) {
            return Timestamps.scaleEpochMillisToMicros(time);
        }
        if (precision < 3L) {
            return Timestamps.round(time, (int)(3L - precision));
        }
        return time;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp cast(@SqlType(value="time") long time) {
        return new LongTimestamp(TimeToTimestampCast.cast(6L, time), 0);
    }
}

