/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.operator.scalar.SequenceFunction;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.spi.type.TimestampType;
import io.prestosql.spi.type.TimestampTypes;

@ScalarFunction(value="sequence")
public final class SequenceIntervalDayToSecond {
    private static final TimestampType SHORT_TYPE = TimestampType.createTimestampType((int)0);
    private static final TimestampType LONG_TYPE = TimestampType.createTimestampType((int)7);

    private SequenceIntervalDayToSecond() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="array(timestamp(p))")
    public static Block sequence(@LiteralParameter(value="p") long precision, @SqlType(value="timestamp(p)") long start, @SqlType(value="timestamp(p)") long stop, @SqlType(value="interval day to second") long step) {
        if (precision > 3L) {
            step = Math.multiplyExact(step, 1000);
        }
        SequenceFunction.checkValidStep(start, stop, step);
        int length = Math.toIntExact((stop - start) / step + 1L);
        SequenceFunction.checkMaxEntry(length);
        BlockBuilder blockBuilder = SHORT_TYPE.createBlockBuilder(null, length);
        long i = 0L;
        long value = start;
        while (i < (long)length) {
            SHORT_TYPE.writeLong(blockBuilder, value);
            ++i;
            value += step;
        }
        return blockBuilder.build();
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="array(timestamp(p))")
    public static Block sequence(@SqlType(value="timestamp(p)") LongTimestamp start, @SqlType(value="timestamp(p)") LongTimestamp stop, @SqlType(value="interval day to second") long step) {
        step = Math.multiplyExact(step, 1000);
        long startMicros = start.getEpochMicros();
        long stopMicros = stop.getEpochMicros();
        SequenceFunction.checkValidStep(startMicros, stopMicros, step);
        int length = Math.toIntExact((stopMicros - startMicros) / step + 1L);
        SequenceFunction.checkMaxEntry(length);
        BlockBuilder blockBuilder = LONG_TYPE.createBlockBuilder(null, length);
        long i = 0L;
        long epochMicros = startMicros;
        while (i < (long)length) {
            TimestampTypes.writeLongTimestamp((BlockBuilder)blockBuilder, (long)epochMicros, (int)start.getPicosOfMicro());
            ++i;
            epochMicros += step;
        }
        return blockBuilder.build();
    }
}

