/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

@ScalarFunction(value="$localtimestamp", hidden=true)
public final class LocalTimestamp {
    private LocalTimestamp() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static long localTimestamp(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="timestamp(p)") Long dummy) {
        Instant start = session.getStart();
        if (!session.isLegacyTimestamp()) {
            start = LocalDateTime.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toInstant(ZoneOffset.UTC);
        }
        long epochMicros = Timestamps.epochSecondToMicrosWithRounding(start.getEpochSecond(), (long)start.getNano() * 1000L);
        epochMicros = Timestamps.round(epochMicros, (int)(6L - precision));
        if (precision <= 3L) {
            epochMicros = Timestamps.scaleEpochMicrosToMillis(epochMicros);
        }
        return epochMicros;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp localTimestamp(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlNullable @SqlType(value="timestamp(p)") LongTimestamp dummy) {
        Instant start = session.getStart();
        if (!session.isLegacyTimestamp()) {
            start = LocalDateTime.ofInstant(session.getStart(), session.getTimeZoneKey().getZoneId()).toInstant(ZoneOffset.UTC);
        }
        return Timestamps.longTimestamp(precision, start);
    }
}

