/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.operator.scalar.timestamp.TimestampToDateCast;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import java.util.concurrent.TimeUnit;
import org.joda.time.chrono.ISOChronology;

@Description(value="Last day of the month of the given timestamp")
@ScalarFunction(value="last_day_of_month")
public class LastDayOfMonth {
    private static final int MILLISECONDS_IN_DAY = 86400000;

    private LastDayOfMonth() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long lastDayOfMonth(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp) {
        if (session.isLegacyTimestamp()) {
            long date = TimestampToDateCast.cast(precision, session, timestamp);
            return DateTimeFunctions.lastDayOfMonthFromDate(date);
        }
        long epochMillis = timestamp;
        if (precision > 3L) {
            epochMillis = Timestamps.scaleEpochMicrosToMillis(timestamp);
        }
        long millis = ISOChronology.getInstanceUTC().monthOfYear().roundCeiling(epochMillis + 1L) - 86400000L;
        return TimeUnit.MILLISECONDS.toDays(millis);
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="date")
    public static long lastDayOfMonth(ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        return LastDayOfMonth.lastDayOfMonth(6L, session, timestamp.getEpochMicros());
    }
}

