/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@Description(value="Truncate to the specified precision in the session timezone")
@ScalarFunction(value="date_trunc")
public final class DateTrunc {
    private DateTrunc() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static long truncate(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p)") long timestamp) {
        if (precision > 3L) {
            timestamp = Timestamps.scaleEpochMicrosToMillis(timestamp);
        }
        long result = session.isLegacyTimestamp() ? DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).roundFloor(timestamp) : DateTimeFunctions.getTimestampField(ISOChronology.getInstanceUTC(), unit).roundFloor(timestamp);
        if (precision > 3L) {
            result = Timestamps.scaleEpochMillisToMicros(result);
        }
        return result;
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="timestamp(p)")
    public static LongTimestamp truncate(ConnectorSession session, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p)") LongTimestamp timestamp) {
        long epochMillis = Timestamps.scaleEpochMicrosToMillis(timestamp.getEpochMicros());
        long result = session.isLegacyTimestamp() ? DateTimeFunctions.getTimestampField(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), unit).roundFloor(epochMillis) : DateTimeFunctions.getTimestampField(ISOChronology.getInstanceUTC(), unit).roundFloor(epochMillis);
        return new LongTimestamp(Timestamps.scaleEpochMillisToMicros(result), 0);
    }
}

