/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@ScalarFunction
@Description(value="Formats the given timestamp by the given format")
public class DateFormat {
    private DateFormat() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") long timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        if (precision > 3L) {
            timestamp = Timestamps.scaleEpochMicrosToMillis(Timestamps.round(timestamp, 3));
        }
        if (session.isLegacyTimestamp()) {
            return DateTimeFunctions.dateFormat(DateTimeZoneIndex.getChronology(session.getTimeZoneKey()), session.getLocale(), timestamp, formatString);
        }
        return DateTimeFunctions.dateFormat(ISOChronology.getInstanceUTC(), session.getLocale(), timestamp, formatString);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar")
    public static Slice format(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="timestamp(p)") LongTimestamp timestamp, @SqlType(value="varchar(x)") Slice formatString) {
        return DateFormat.format(6L, session, timestamp.getEpochMicros(), formatString);
    }
}

