/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar.timestamp;

import io.airlift.slice.Slice;
import io.prestosql.operator.scalar.DateTimeFunctions;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.LiteralParameter;
import io.prestosql.spi.function.LiteralParameters;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.type.LongTimestamp;
import io.prestosql.type.Timestamps;
import io.prestosql.util.DateTimeZoneIndex;
import org.joda.time.chrono.ISOChronology;

@Description(value="Difference of the given times in the given unit")
@ScalarFunction(value="date_diff")
public class DateDiff {
    private DateDiff() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(@LiteralParameter(value="p") long precision, ConnectorSession session, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p)") long timestamp1, @SqlType(value="timestamp(p)") long timestamp2) {
        long epochMillis1 = timestamp1;
        long epochMillis2 = timestamp2;
        if (precision > 3L) {
            epochMillis1 = Timestamps.scaleEpochMicrosToMillis(timestamp1);
            epochMillis2 = Timestamps.scaleEpochMicrosToMillis(timestamp2);
        }
        ISOChronology chronology = ISOChronology.getInstanceUTC();
        if (session.isLegacyTimestamp()) {
            chronology = DateTimeZoneIndex.getChronology(session.getTimeZoneKey());
        }
        return DateTimeFunctions.getTimestampField(chronology, unit).getDifferenceAsLong(epochMillis2, epochMillis1);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="bigint")
    public static long diff(ConnectorSession session, @SqlType(value="varchar(x)") Slice unit, @SqlType(value="timestamp(p)") LongTimestamp timestamp1, @SqlType(value="timestamp(p)") LongTimestamp timestamp2) {
        return DateDiff.diff(6L, session, unit, timestamp1.getEpochMicros(), timestamp2.getEpochMicros());
    }
}

