/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.annotations.VisibleForTesting;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SignatureBinder;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.operator.ParametricImplementationsGroup;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.operator.scalar.ScalarHeader;
import io.prestosql.operator.scalar.annotations.ParametricScalarImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.util.Failures;
import java.util.Objects;
import java.util.Optional;

public class ParametricScalar
extends SqlScalarFunction {
    private final ScalarHeader details;
    private final ParametricImplementationsGroup<ParametricScalarImplementation> implementations;

    public ParametricScalar(Signature signature, ScalarHeader details, ParametricImplementationsGroup<ParametricScalarImplementation> implementations, boolean deprecated) {
        super(new FunctionMetadata(signature, implementations.isNullable(), implementations.getArgumentDefinitions(), details.isHidden(), details.isDeterministic(), details.getDescription().orElse(""), FunctionKind.SCALAR, deprecated));
        this.details = Objects.requireNonNull(details);
        this.implementations = Objects.requireNonNull(implementations);
    }

    @VisibleForTesting
    public ParametricImplementationsGroup<ParametricScalarImplementation> getImplementations() {
        return this.implementations;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        Optional<ScalarFunctionImplementation> scalarFunctionImplementation;
        Signature boundSignature = SignatureBinder.applyBoundVariables(this.getFunctionMetadata().getSignature(), boundVariables, arity);
        if (this.implementations.getExactImplementations().containsKey(boundSignature)) {
            ParametricScalarImplementation implementation = this.implementations.getExactImplementations().get(boundSignature);
            Optional<ScalarFunctionImplementation> scalarFunctionImplementation2 = implementation.specialize(boundSignature, boundVariables, metadata);
            Failures.checkCondition(scalarFunctionImplementation2.isPresent(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Exact implementation of %s do not match expected java types.", boundSignature.getName()), new Object[0]);
            return scalarFunctionImplementation2.get();
        }
        ScalarFunctionImplementation selectedImplementation = null;
        for (ParametricScalarImplementation implementation : this.implementations.getSpecializedImplementations()) {
            scalarFunctionImplementation = implementation.specialize(boundSignature, boundVariables, metadata);
            if (!scalarFunctionImplementation.isPresent()) continue;
            Failures.checkCondition(selectedImplementation == null, (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_IMPLEMENTATION, "Ambiguous implementation for %s with bindings %s", this.getFunctionMetadata().getSignature(), boundVariables.getBindings());
            selectedImplementation = scalarFunctionImplementation.get();
        }
        if (selectedImplementation != null) {
            return selectedImplementation;
        }
        for (ParametricScalarImplementation implementation : this.implementations.getGenericImplementations()) {
            scalarFunctionImplementation = implementation.specialize(boundSignature, boundVariables, metadata);
            if (!scalarFunctionImplementation.isPresent()) continue;
            Failures.checkCondition(selectedImplementation == null, (ErrorCodeSupplier)StandardErrorCode.AMBIGUOUS_FUNCTION_IMPLEMENTATION, "Ambiguous implementation for %s with bindings %s", this.getFunctionMetadata().getSignature(), boundVariables.getBindings());
            selectedImplementation = scalarFunctionImplementation.get();
        }
        if (selectedImplementation != null) {
            return selectedImplementation;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING, String.format("Unsupported type parameters (%s) for %s", boundVariables, this.getFunctionMetadata().getSignature()));
    }
}

