/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.prestosql.operator.scalar.MapGenericEquality;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarOperator;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.function.TypeParameters;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.EQUAL)
public final class MapEqualOperator {
    private MapEqualOperator() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlNullable
    @SqlType(value="boolean")
    public static Boolean equals(@OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle keyEqualsFunction, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}) MethodHandle keyHashcodeFunction, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"V", "V"}) MethodHandle valueEqualsFunction, @TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType, @SqlType(value="map(K,V)") Block leftMapBlock, @SqlType(value="map(K,V)") Block rightMapBlock) {
        return MapGenericEquality.genericEqual(keyType, leftMapBlock, rightMapBlock, (leftMapIndex, rightMapIndex) -> {
            Object leftValue = TypeUtils.readNativeValue((Type)valueType, (Block)leftMapBlock, (int)leftMapIndex);
            if (leftValue == null) {
                return null;
            }
            Object rightValue = TypeUtils.readNativeValue((Type)valueType, (Block)rightMapBlock, (int)rightMapIndex);
            if (rightValue == null) {
                return null;
            }
            return valueEqualsFunction.invoke(leftValue, rightValue);
        });
    }
}

