/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@Description(value="Returns the position of the first occurrence of the given value in array (or 0 if not found)")
@ScalarFunction(value="array_position")
public final class ArrayPositionFunction {
    private ArrayPositionFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") boolean element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            boolean arrayValue = type.getBoolean(array, i);
            try {
                Boolean result = equalMethodHandle.invokeExact(arrayValue, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") long element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            long arrayValue = type.getLong(array, i);
            try {
                Boolean result = equalMethodHandle.invokeExact(arrayValue, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") double element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            double arrayValue = type.getDouble(array, i);
            try {
                Boolean result = equalMethodHandle.invokeExact(arrayValue, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Slice element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            Slice arrayValue = type.getSlice(array, i);
            try {
                Boolean result = equalMethodHandle.invokeExact(arrayValue, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Block element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            Object arrayValue = type.getObject(array, i);
            try {
                Boolean result = equalMethodHandle.invoke(arrayValue, element);
                ArrayPositionFunction.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return i + 1;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return 0L;
    }

    private static void checkNotIndeterminate(Boolean equalsResult) {
        if (equalsResult == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "array_position does not support arrays with elements that are null or contain null");
        }
    }
}

