/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.prestosql.annotation.UsedByGeneratedCode;
import io.prestosql.metadata.BoundVariables;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.LongVariableConstraint;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlScalarFunction;
import io.prestosql.metadata.TypeVariableConstraint;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PageBuilder;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.spi.type.TypeSignatureParameter;
import io.prestosql.spi.type.VarcharType;
import io.prestosql.type.UnknownType;
import io.prestosql.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.Optional;

public final class ArrayJoin
extends SqlScalarFunction {
    public static final ArrayJoin ARRAY_JOIN = new ArrayJoin();
    public static final ArrayJoinWithNullReplacement ARRAY_JOIN_WITH_NULL_REPLACEMENT = new ArrayJoinWithNullReplacement();
    private static final String FUNCTION_NAME = "array_join";
    private static final String DESCRIPTION = "Concatenates the elements of the given array using a delimiter and an optional string to replace nulls";
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayJoin.class, "arrayJoin", MethodHandle.class, Object.class, ConnectorSession.class, Block.class, Slice.class);
    private static final MethodHandle GET_BOOLEAN = Reflection.methodHandle(Type.class, "getBoolean", Block.class, Integer.TYPE);
    private static final MethodHandle GET_DOUBLE = Reflection.methodHandle(Type.class, "getDouble", Block.class, Integer.TYPE);
    private static final MethodHandle GET_LONG = Reflection.methodHandle(Type.class, "getLong", Block.class, Integer.TYPE);
    private static final MethodHandle GET_SLICE = Reflection.methodHandle(Type.class, "getSlice", Block.class, Integer.TYPE);
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(ArrayJoin.class, "createState", new Class[0]);

    public ArrayJoin() {
        super(new FunctionMetadata(new Signature(FUNCTION_NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.castableToTypeParameter("T", VarcharType.VARCHAR.getTypeSignature())), (List<LongVariableConstraint>)ImmutableList.of(), VarcharType.VARCHAR.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), (Object)VarcharType.VARCHAR.getTypeSignature()), false), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, true, DESCRIPTION, FunctionKind.SCALAR));
    }

    @UsedByGeneratedCode
    public static Object createState() {
        return new PageBuilder((List)ImmutableList.of((Object)VarcharType.VARCHAR));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
        return ArrayJoin.specializeArrayJoin(boundVariables, metadata, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), METHOD_HANDLE);
    }

    private static ScalarFunctionImplementation specializeArrayJoin(BoundVariables types, Metadata metadata, List<Boolean> nullableArguments, MethodHandle methodHandle) {
        Type type = types.getTypeVariable("T");
        List argumentProperties = (List)nullableArguments.stream().map(nullable -> nullable != false ? ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.USE_BOXED_TYPE) : ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)).collect(ImmutableList.toImmutableList());
        if (type instanceof UnknownType) {
            return new ScalarFunctionImplementation(false, argumentProperties, methodHandle.bindTo(null), Optional.of(STATE_FACTORY));
        }
        try {
            MethodHandle getter;
            ResolvedFunction resolvedFunction = metadata.getCoercion(type, (Type)VarcharType.VARCHAR);
            MethodHandle cast = metadata.getScalarFunctionInvoker(resolvedFunction, Optional.empty()).getMethodHandle();
            Class elementType = type.getJavaType();
            if (elementType == Boolean.TYPE) {
                getter = GET_BOOLEAN;
            } else if (elementType == Double.TYPE) {
                getter = GET_DOUBLE;
            } else if (elementType == Long.TYPE) {
                getter = GET_LONG;
            } else if (elementType == Slice.class) {
                getter = GET_SLICE;
            } else {
                throw new UnsupportedOperationException("Unsupported type: " + elementType.getName());
            }
            if (cast.type().parameterArray()[0] != ConnectorSession.class) {
                cast = MethodHandles.dropArguments(cast, 0, new Class[]{ConnectorSession.class});
            }
            cast = MethodHandles.permuteArguments(cast, MethodType.methodType(Slice.class, cast.type().parameterArray()[1], cast.type().parameterArray()[0]), 1, 0);
            cast = MethodHandles.dropArguments(cast, 1, new Class[]{Integer.TYPE});
            cast = MethodHandles.dropArguments(cast, 1, new Class[]{Block.class});
            cast = MethodHandles.foldArguments(cast, getter.bindTo(type));
            MethodHandle target = MethodHandles.insertArguments(methodHandle, 0, cast);
            return new ScalarFunctionImplementation(false, argumentProperties, target, Optional.of(STATE_FACTORY));
        }
        catch (PrestoException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Input type %s not supported", type), (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice arrayJoin(MethodHandle castFunction, Object state, ConnectorSession session, Block arrayBlock, Slice delimiter) {
        return ArrayJoin.arrayJoin(castFunction, state, session, arrayBlock, delimiter, null);
    }

    @UsedByGeneratedCode
    public static Slice arrayJoin(MethodHandle castFunction, Object state, ConnectorSession session, Block arrayBlock, Slice delimiter, Slice nullReplacement) {
        PageBuilder pageBuilder = (PageBuilder)state;
        if (pageBuilder.isFull()) {
            pageBuilder.reset();
        }
        int numElements = arrayBlock.getPositionCount();
        BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(0);
        for (int i = 0; i < numElements; ++i) {
            if (arrayBlock.isNull(i)) {
                if (nullReplacement == null) continue;
                blockBuilder.writeBytes(nullReplacement, 0, nullReplacement.length());
            } else {
                try {
                    Slice slice = castFunction.invokeExact(arrayBlock, i, session);
                    blockBuilder.writeBytes(slice, 0, slice.length());
                }
                catch (Throwable throwable) {
                    blockBuilder.closeEntry();
                    pageBuilder.declarePosition();
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error casting array element to VARCHAR", throwable);
                }
            }
            if (i == numElements - 1) continue;
            blockBuilder.writeBytes(delimiter, 0, delimiter.length());
        }
        blockBuilder.closeEntry();
        pageBuilder.declarePosition();
        return VarcharType.VARCHAR.getSlice((Block)blockBuilder, blockBuilder.getPositionCount() - 1);
    }

    public static class ArrayJoinWithNullReplacement
    extends SqlScalarFunction {
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayJoin.class, "arrayJoin", MethodHandle.class, Object.class, ConnectorSession.class, Block.class, Slice.class, Slice.class);

        public ArrayJoinWithNullReplacement() {
            super(new FunctionMetadata(new Signature(ArrayJoin.FUNCTION_NAME, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), VarcharType.VARCHAR.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0])), (Object)VarcharType.VARCHAR.getTypeSignature(), (Object)VarcharType.VARCHAR.getTypeSignature()), false), false, (List<FunctionArgumentDefinition>)ImmutableList.of((Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false), (Object)new FunctionArgumentDefinition(false)), false, true, ArrayJoin.DESCRIPTION, FunctionKind.SCALAR));
        }

        @Override
        public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, Metadata metadata) {
            return ArrayJoin.specializeArrayJoin(boundVariables, metadata, (List<Boolean>)ImmutableList.of((Object)false, (Object)false, (Object)false), METHOD_HANDLE);
        }
    }
}

