/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.scalar;

import io.airlift.slice.Slice;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.function.Convention;
import io.prestosql.spi.function.Description;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorDependency;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.function.ScalarFunction;
import io.prestosql.spi.function.SqlNullable;
import io.prestosql.spi.function.SqlType;
import io.prestosql.spi.function.TypeParameter;
import io.prestosql.spi.type.Type;
import io.prestosql.util.Failures;
import java.lang.invoke.MethodHandle;

@Description(value="Determines whether given value exists in the array")
@ScalarFunction(value="contains")
public final class ArrayContains {
    private ArrayContains() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") Block value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact((Block)elementType.getObject(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") Slice value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(elementType.getSlice(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") long value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(elementType.getLong(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") boolean value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(elementType.getBoolean(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") double value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(elementType.getDouble(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    private static void checkNotIndeterminate(Boolean equalsResult) {
        if (equalsResult == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "contains does not support arrays with elements that are null or contain null");
        }
    }
}

