/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.operator.aggregation.state;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.airlift.bytecode.Access;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.ClassDefinition;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.bytecode.FieldDefinition;
import io.airlift.bytecode.MethodDefinition;
import io.airlift.bytecode.Parameter;
import io.airlift.bytecode.ParameterizedType;
import io.airlift.bytecode.Scope;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpression;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.slice.Slice;
import io.prestosql.array.BlockBigArray;
import io.prestosql.array.BooleanBigArray;
import io.prestosql.array.ByteBigArray;
import io.prestosql.array.DoubleBigArray;
import io.prestosql.array.IntBigArray;
import io.prestosql.array.LongBigArray;
import io.prestosql.array.ObjectBigArray;
import io.prestosql.array.SliceBigArray;
import io.prestosql.operator.aggregation.GroupedAccumulator;
import io.prestosql.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.prestosql.operator.aggregation.state.InitialBooleanValue;
import io.prestosql.operator.aggregation.state.InitialDoubleValue;
import io.prestosql.operator.aggregation.state.InitialLongValue;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.function.AccumulatorStateFactory;
import io.prestosql.spi.function.AccumulatorStateMetadata;
import io.prestosql.spi.function.AccumulatorStateSerializer;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.DoubleType;
import io.prestosql.spi.type.IntegerType;
import io.prestosql.spi.type.RowType;
import io.prestosql.spi.type.TinyintType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarbinaryType;
import io.prestosql.sql.gen.CallSiteBinder;
import io.prestosql.sql.gen.SqlTypeBytecodeExpression;
import io.prestosql.type.UnknownType;
import io.prestosql.util.CompilerUtils;
import java.lang.annotation.Annotation;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openjdk.jol.info.ClassLayout;

public final class StateCompiler {
    private StateCompiler() {
    }

    private static Class<?> getBigArrayType(Class<?> type) {
        if (type.equals(Long.TYPE)) {
            return LongBigArray.class;
        }
        if (type.equals(Byte.TYPE)) {
            return ByteBigArray.class;
        }
        if (type.equals(Double.TYPE)) {
            return DoubleBigArray.class;
        }
        if (type.equals(Boolean.TYPE)) {
            return BooleanBigArray.class;
        }
        if (type.equals(Integer.TYPE)) {
            return IntBigArray.class;
        }
        if (type.equals(Slice.class)) {
            return SliceBigArray.class;
        }
        if (type.equals(Block.class)) {
            return BlockBigArray.class;
        }
        return ObjectBigArray.class;
    }

    public static <T> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz) {
        return StateCompiler.generateStateSerializer(clazz, new DynamicClassLoader(clazz.getClassLoader()));
    }

    public static <T> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz, DynamicClassLoader classLoader) {
        return StateCompiler.generateStateSerializer(clazz, (Map<String, Type>)ImmutableMap.of(), classLoader);
    }

    public static <T> AccumulatorStateSerializer<T> generateStateSerializer(Class<T> clazz, Map<String, Type> fieldTypes, DynamicClassLoader classLoader) {
        AccumulatorStateMetadata metadata = StateCompiler.getMetadataAnnotation(clazz);
        if (metadata != null && metadata.stateSerializerClass() != Void.TYPE) {
            try {
                return (AccumulatorStateSerializer)metadata.stateSerializerClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(clazz.getSimpleName() + "Serializer"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(AccumulatorStateSerializer.class)});
        CallSiteBinder callSiteBinder = new CallSiteBinder();
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        List<StateField> fields = StateCompiler.enumerateFields(clazz, fieldTypes);
        StateCompiler.generateGetSerializedType(definition, fields, callSiteBinder);
        StateCompiler.generateSerialize(definition, callSiteBinder, clazz, fields);
        StateCompiler.generateDeserialize(definition, callSiteBinder, clazz, fields);
        Class<AccumulatorStateSerializer> serializerClass = CompilerUtils.defineClass(definition, AccumulatorStateSerializer.class, callSiteBinder.getBindings(), (ClassLoader)classLoader);
        try {
            return serializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void generateGetSerializedType(ClassDefinition definition, List<StateField> fields, CallSiteBinder callSiteBinder) {
        UnknownType type;
        BytecodeBlock body = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getSerializedType", ParameterizedType.type(Type.class), new Parameter[0]).getBody();
        if (fields.size() > 1) {
            List types = (List)fields.stream().map(StateField::getSqlType).collect(ImmutableList.toImmutableList());
            type = RowType.anonymous((List)types);
        } else {
            type = fields.size() == 1 ? ((StateField)Iterables.getOnlyElement(fields)).getSqlType() : UnknownType.UNKNOWN;
        }
        body.comment("return %s", new Object[]{type.getTypeSignature()}).append((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, (Type)type)).retObject();
    }

    private static <T> AccumulatorStateMetadata getMetadataAnnotation(Class<T> clazz) {
        AccumulatorStateMetadata metadata = clazz.getAnnotation(AccumulatorStateMetadata.class);
        if (metadata != null) {
            return metadata;
        }
        for (Class<?> superInterface : clazz.getInterfaces()) {
            metadata = superInterface.getAnnotation(AccumulatorStateMetadata.class);
            if (metadata == null) continue;
            return metadata;
        }
        return null;
    }

    private static <T> void generateDeserialize(ClassDefinition definition, CallSiteBinder binder, Class<T> clazz, List<StateField> fields) {
        Parameter block = Parameter.arg((String)"block", Block.class);
        Parameter index = Parameter.arg((String)"index", Integer.TYPE);
        Parameter state = Parameter.arg((String)"state", Object.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "deserialize", ParameterizedType.type(Void.TYPE), new Parameter[]{block, index, state});
        BytecodeBlock deserializerBody = method.getBody();
        Scope scope = method.getScope();
        if (fields.size() == 1) {
            StateField field = (StateField)Iterables.getOnlyElement(fields);
            Method setter = StateCompiler.getSetter(clazz, field);
            if (!field.isPrimitiveType()) {
                deserializerBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{index})).ifTrue((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{BytecodeExpressions.constantNull(field.getType())})).ifFalse((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, field.getSqlType()).getValue((BytecodeExpression)block, (BytecodeExpression)index)})));
            } else {
                deserializerBody.append((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, field.getSqlType()).getValue((BytecodeExpression)block, (BytecodeExpression)index).cast(field.getType())}));
            }
        } else if (fields.size() > 1) {
            Variable row = scope.declareVariable(Block.class, "row");
            deserializerBody.append((BytecodeNode)row.set(block.invoke("getObject", Object.class, new BytecodeExpression[]{index, BytecodeExpressions.constantClass(Block.class)}).cast(Block.class)));
            int position = 0;
            for (StateField field : fields) {
                Method setter = StateCompiler.getSetter(clazz, field);
                if (!field.isPrimitiveType()) {
                    deserializerBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)row.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{BytecodeExpressions.constantInt((int)position)})).ifTrue((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{BytecodeExpressions.constantNull(field.getType())})).ifFalse((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, field.getSqlType()).getValue((BytecodeExpression)row, BytecodeExpressions.constantInt((int)position))})));
                } else {
                    deserializerBody.append((BytecodeNode)state.cast(setter.getDeclaringClass()).invoke(setter, new BytecodeExpression[]{SqlTypeBytecodeExpression.constantType(binder, field.getSqlType()).getValue((BytecodeExpression)row, BytecodeExpressions.constantInt((int)position)).cast(field.getType())}));
                }
                ++position;
            }
        }
        deserializerBody.ret();
    }

    private static <T> void generateSerialize(ClassDefinition definition, CallSiteBinder binder, Class<T> clazz, List<StateField> fields) {
        Parameter state = Parameter.arg((String)"state", Object.class);
        Parameter out = Parameter.arg((String)"out", BlockBuilder.class);
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "serialize", ParameterizedType.type(Void.TYPE), new Parameter[]{state, out});
        Scope scope = method.getScope();
        BytecodeBlock serializerBody = method.getBody();
        if (fields.size() == 0) {
            serializerBody.append((BytecodeNode)out.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop());
        } else if (fields.size() == 1) {
            Method getter = StateCompiler.getGetter(clazz, (StateField)Iterables.getOnlyElement(fields));
            SqlTypeBytecodeExpression sqlType = SqlTypeBytecodeExpression.constantType(binder, ((StateField)Iterables.getOnlyElement(fields)).getSqlType());
            Variable fieldValue = scope.declareVariable(getter.getReturnType(), "value");
            serializerBody.append((BytecodeNode)fieldValue.set(state.cast(getter.getDeclaringClass()).invoke(getter, new BytecodeExpression[0])));
            if (!((StateField)Iterables.getOnlyElement(fields)).isPrimitiveType()) {
                serializerBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)fieldValue, (BytecodeExpression)BytecodeExpressions.constantNull(getter.getReturnType()))).ifTrue((BytecodeNode)out.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)sqlType.writeValue((BytecodeExpression)out, (BytecodeExpression)fieldValue)));
            } else {
                serializerBody.append((BytecodeNode)sqlType.writeValue((BytecodeExpression)out, fieldValue.cast(((StateField)Iterables.getOnlyElement(fields)).getSqlType().getJavaType())));
            }
        } else if (fields.size() > 1) {
            Variable rowBuilder = scope.declareVariable(BlockBuilder.class, "rowBuilder");
            serializerBody.append((BytecodeNode)rowBuilder.set(out.invoke("beginBlockEntry", BlockBuilder.class, new BytecodeExpression[0])));
            for (StateField field : fields) {
                Method getter = StateCompiler.getGetter(clazz, field);
                SqlTypeBytecodeExpression sqlType = SqlTypeBytecodeExpression.constantType(binder, field.getSqlType());
                Variable fieldValue = scope.createTempVariable(getter.getReturnType());
                serializerBody.append((BytecodeNode)fieldValue.set(state.cast(getter.getDeclaringClass()).invoke(getter, new BytecodeExpression[0])));
                if (!field.isPrimitiveType()) {
                    serializerBody.append((BytecodeNode)new IfStatement().condition((BytecodeNode)BytecodeExpressions.equal((BytecodeExpression)fieldValue, (BytecodeExpression)BytecodeExpressions.constantNull(getter.getReturnType()))).ifTrue((BytecodeNode)rowBuilder.invoke("appendNull", BlockBuilder.class, new BytecodeExpression[0]).pop()).ifFalse((BytecodeNode)sqlType.writeValue((BytecodeExpression)rowBuilder, (BytecodeExpression)fieldValue)));
                    continue;
                }
                serializerBody.append((BytecodeNode)sqlType.writeValue((BytecodeExpression)rowBuilder, fieldValue.cast(field.getSqlType().getJavaType())));
            }
            serializerBody.append((BytecodeNode)out.invoke("closeEntry", BlockBuilder.class, new BytecodeExpression[0]).pop());
        }
        serializerBody.ret();
    }

    private static Method getSetter(Class<?> clazz, StateField field) {
        try {
            return clazz.getMethod(field.getSetterName(), field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getGetter(Class<?> clazz, StateField field) {
        try {
            return clazz.getMethod(field.getGetterName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz) {
        return StateCompiler.generateStateFactory(clazz, new DynamicClassLoader(clazz.getClassLoader()));
    }

    public static <T> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz, DynamicClassLoader classLoader) {
        return StateCompiler.generateStateFactory(clazz, (Map<String, Type>)ImmutableMap.of(), classLoader);
    }

    public static <T> AccumulatorStateFactory<T> generateStateFactory(Class<T> clazz, Map<String, Type> fieldTypes, DynamicClassLoader classLoader) {
        AccumulatorStateMetadata metadata = StateCompiler.getMetadataAnnotation(clazz);
        if (metadata != null && metadata.stateFactoryClass() != Void.TYPE) {
            try {
                return (AccumulatorStateFactory)metadata.stateFactoryClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        Class<T> singleStateClass = StateCompiler.generateSingleStateClass(clazz, fieldTypes, classLoader);
        Class<T> groupedStateClass = StateCompiler.generateGroupedStateClass(clazz, fieldTypes, classLoader);
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName(clazz.getSimpleName() + "Factory"), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(AccumulatorStateFactory.class)});
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}));
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "createSingleState", ParameterizedType.type(Object.class), new Parameter[0]).getBody().newObject(singleStateClass).dup().invokeConstructor(singleStateClass, new Class[0]).retObject();
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "createGroupedState", ParameterizedType.type(Object.class), new Parameter[0]).getBody().newObject(groupedStateClass).dup().invokeConstructor(groupedStateClass, new Class[0]).retObject();
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getSingleStateClass", ParameterizedType.type(Class.class, (Class[])new Class[]{singleStateClass}), new Parameter[0]).getBody().push(singleStateClass).retObject();
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getGroupedStateClass", ParameterizedType.type(Class.class, (Class[])new Class[]{groupedStateClass}), new Parameter[0]).getBody().push(groupedStateClass).retObject();
        Class<AccumulatorStateFactory> factoryClass = CompilerUtils.defineClass(definition, AccumulatorStateFactory.class, classLoader);
        try {
            return factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> Class<? extends T> generateSingleStateClass(Class<T> clazz, Map<String, Type> fieldTypes, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("Single" + clazz.getSimpleName()), ParameterizedType.type(Object.class), new ParameterizedType[]{ParameterizedType.type(clazz)});
        FieldDefinition instanceSize = StateCompiler.generateInstanceSize(definition);
        definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]).getBody().getStaticField(instanceSize).retLong();
        MethodDefinition constructor = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        constructor.getBody().append((BytecodeNode)constructor.getThis()).invokeConstructor(Object.class, new Class[0]);
        List<StateField> fields = StateCompiler.enumerateFields(clazz, fieldTypes);
        for (StateField field : fields) {
            StateCompiler.generateField(definition, constructor, field);
        }
        constructor.getBody().ret();
        return CompilerUtils.defineClass(definition, clazz, classLoader);
    }

    private static FieldDefinition generateInstanceSize(ClassDefinition definition) {
        FieldDefinition instanceSize = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE, Access.STATIC, Access.FINAL}), "INSTANCE_SIZE", Long.TYPE);
        definition.getClassInitializer().getBody().comment("INSTANCE_SIZE = ClassLayout.parseClass(%s.class).instanceSize()", new Object[]{definition.getName()}).push(definition.getType()).invokeStatic(ClassLayout.class, "parseClass", ClassLayout.class, new Class[]{Class.class}).invokeVirtual(ClassLayout.class, "instanceSize", Integer.TYPE, new Class[0]).intToLong().putStaticField(instanceSize);
        return instanceSize;
    }

    private static <T> Class<? extends T> generateGroupedStateClass(Class<T> clazz, Map<String, Type> fieldTypes, DynamicClassLoader classLoader) {
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName("Grouped" + clazz.getSimpleName()), ParameterizedType.type(AbstractGroupedAccumulatorState.class), new ParameterizedType[]{ParameterizedType.type(clazz), ParameterizedType.type(GroupedAccumulator.class)});
        FieldDefinition instanceSize = StateCompiler.generateInstanceSize(definition);
        List<StateField> fields = StateCompiler.enumerateFields(clazz, fieldTypes);
        MethodDefinition constructor = definition.declareConstructor(Access.a((Access[])new Access[]{Access.PUBLIC}), new Parameter[0]);
        constructor.getBody().append((BytecodeNode)constructor.getThis()).invokeConstructor(AbstractGroupedAccumulatorState.class, new Class[0]);
        MethodDefinition ensureCapacity = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "ensureCapacity", ParameterizedType.type(Void.TYPE), new Parameter[]{Parameter.arg((String)"size", Long.TYPE)});
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        for (StateField field : fields) {
            fieldDefinitions.add(StateCompiler.generateGroupedField(definition, constructor, ensureCapacity, field));
        }
        constructor.getBody().ret();
        ensureCapacity.getBody().ret();
        MethodDefinition getEstimatedSize = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), "getEstimatedSize", ParameterizedType.type(Long.TYPE), new Parameter[0]);
        BytecodeBlock body = getEstimatedSize.getBody();
        Variable size = getEstimatedSize.getScope().declareVariable(Long.TYPE, "size");
        body.append((BytecodeNode)size.set(BytecodeExpressions.getStatic((FieldDefinition)instanceSize)));
        for (FieldDefinition field : fieldDefinitions) {
            body.append((BytecodeNode)size.set(BytecodeExpressions.add((BytecodeExpression)size, (BytecodeExpression)getEstimatedSize.getThis().getField(field).invoke("sizeOf", Long.TYPE, new BytecodeExpression[0]))));
        }
        body.append((BytecodeNode)size.ret());
        return CompilerUtils.defineClass(definition, clazz, classLoader);
    }

    private static void generateField(ClassDefinition definition, MethodDefinition constructor, StateField stateField) {
        FieldDefinition field = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stateField.getName()) + "Value", stateField.getType());
        MethodDefinition getter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), stateField.getGetterName(), ParameterizedType.type(stateField.getType()), new Parameter[0]);
        getter.getBody().append((BytecodeNode)getter.getThis().getField(field).ret());
        Parameter value = Parameter.arg((String)"value", stateField.getType());
        MethodDefinition setter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), stateField.getSetterName(), ParameterizedType.type(Void.TYPE), new Parameter[]{value});
        setter.getBody().append((BytecodeNode)setter.getThis().setField(field, (BytecodeExpression)value)).ret();
        constructor.getBody().append((BytecodeNode)constructor.getThis().setField(field, stateField.initialValueExpression()));
    }

    private static FieldDefinition generateGroupedField(ClassDefinition definition, MethodDefinition constructor, MethodDefinition ensureCapacity, StateField stateField) {
        Class<?> bigArrayType = StateCompiler.getBigArrayType(stateField.getType());
        FieldDefinition field = definition.declareField(Access.a((Access[])new Access[]{Access.PRIVATE}), CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, stateField.getName()) + "Values", bigArrayType);
        MethodDefinition getter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), stateField.getGetterName(), ParameterizedType.type(stateField.getType()), new Parameter[0]);
        getter.getBody().append((BytecodeNode)getter.getThis().getField(field).invoke("get", stateField.getType(), new BytecodeExpression[]{getter.getThis().invoke("getGroupId", Long.TYPE, new BytecodeExpression[0])}).ret());
        Parameter value = Parameter.arg((String)"value", stateField.getType());
        MethodDefinition setter = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC}), stateField.getSetterName(), ParameterizedType.type(Void.TYPE), new Parameter[]{value});
        setter.getBody().append((BytecodeNode)setter.getThis().getField(field).invoke("set", Void.TYPE, new BytecodeExpression[]{setter.getThis().invoke("getGroupId", Long.TYPE, new BytecodeExpression[0]), value})).ret();
        Scope ensureCapacityScope = ensureCapacity.getScope();
        ensureCapacity.getBody().append((BytecodeNode)ensureCapacity.getThis().getField(field).invoke("ensureCapacity", Void.TYPE, new BytecodeExpression[]{ensureCapacityScope.getVariable("size")}));
        constructor.getBody().append((BytecodeNode)constructor.getThis().setField(field, BytecodeExpressions.newInstance((ParameterizedType)field.getType(), (BytecodeExpression[])new BytecodeExpression[]{stateField.initialValueExpression()})));
        return field;
    }

    private static List<StateField> enumerateFields(Class<?> clazz, Map<String, Type> fieldTypes) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet primitiveClasses = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Long.TYPE, Double.TYPE, Integer.TYPE);
        for (Method method : clazz.getMethods()) {
            String name;
            Class<?> type;
            if (method.getName().equals("getEstimatedSize")) continue;
            if (method.getName().startsWith("get")) {
                type = method.getReturnType();
                name = method.getName().substring(3);
                builder.add((Object)new StateField(name, type, StateCompiler.getInitialValue(method), method.getName(), Optional.ofNullable(fieldTypes.get(name))));
            }
            if (!method.getName().startsWith("is")) continue;
            type = method.getReturnType();
            Preconditions.checkArgument((type == Boolean.TYPE ? 1 : 0) != 0, (Object)"Only boolean is support for 'is' methods");
            name = method.getName().substring(2);
            builder.add((Object)new StateField(name, type, StateCompiler.getInitialValue(method), method.getName(), Optional.of(BooleanType.BOOLEAN)));
        }
        Ordering<StateField> ordering = new Ordering<StateField>((Set)primitiveClasses){
            final /* synthetic */ Set val$primitiveClasses;
            {
                this.val$primitiveClasses = set;
            }

            public int compare(StateField left, StateField right) {
                if (this.val$primitiveClasses.contains(left.getType()) && !this.val$primitiveClasses.contains(right.getType())) {
                    return -1;
                }
                if (this.val$primitiveClasses.contains(right.getType()) && !this.val$primitiveClasses.contains(left.getType())) {
                    return 1;
                }
                return left.getName().compareTo(right.getName());
            }
        };
        List fields = ordering.sortedCopy((Iterable)builder.build());
        StateCompiler.checkInterface(clazz, fields);
        return fields;
    }

    private static Object getInitialValue(Method method) {
        Constable value = null;
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof InitialLongValue) {
                Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object)method.getName());
                Preconditions.checkArgument((method.getReturnType() == Long.TYPE ? 1 : 0) != 0, (String)"%s does not return a long, but is annotated with @InitialLongValue", (Object)method.getName());
                value = ((InitialLongValue)annotation).value();
                continue;
            }
            if (annotation instanceof InitialDoubleValue) {
                Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object)method.getName());
                Preconditions.checkArgument((method.getReturnType() == Double.TYPE ? 1 : 0) != 0, (String)"%s does not return a double, but is annotated with @InitialDoubleValue", (Object)method.getName());
                value = ((InitialDoubleValue)annotation).value();
                continue;
            }
            if (!(annotation instanceof InitialBooleanValue)) continue;
            Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"%s has multiple initialValue annotations", (Object)method.getName());
            Preconditions.checkArgument((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)"%s does not return a boolean, but is annotated with @InitialBooleanValue", (Object)method.getName());
            value = Boolean.valueOf(((InitialBooleanValue)annotation).value());
        }
        return value;
    }

    private static void checkInterface(Class<?> clazz, List<StateField> fields) {
        Preconditions.checkArgument((boolean)clazz.isInterface(), (Object)(clazz.getName() + " is not an interface"));
        HashSet<String> setters = new HashSet<String>();
        HashSet<String> getters = new HashSet<String>();
        HashSet<String> isGetters = new HashSet<String>();
        HashMap fieldTypes = new HashMap();
        for (StateField field : fields) {
            fieldTypes.put(field.getName(), field.getType());
        }
        for (Method method : clazz.getMethods()) {
            String name;
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (method.getName().equals("getEstimatedSize")) {
                Preconditions.checkArgument((boolean)method.getReturnType().equals(Long.TYPE), (Object)"getEstimatedSize must return long");
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"getEstimatedSize may not have parameters");
                continue;
            }
            if (method.getName().startsWith("get")) {
                name = method.getName().substring(3);
                Preconditions.checkArgument((boolean)((Class)fieldTypes.get(name)).equals(method.getReturnType()), (String)"Expected %s to return type %s, but found %s", (Object)method.getName(), fieldTypes.get(name), method.getReturnType());
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Expected %s to have zero parameters", (Object)method.getName());
                getters.add(name);
                continue;
            }
            if (method.getName().startsWith("is")) {
                name = method.getName().substring(2);
                Preconditions.checkArgument((fieldTypes.get(name) == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected %s to have type boolean, but found %s", (Object)name, fieldTypes.get(name));
                Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (String)"Expected %s to have zero parameters", (Object)method.getName());
                Preconditions.checkArgument((method.getReturnType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Expected %s to return boolean", (Object)method.getName());
                isGetters.add(name);
                continue;
            }
            if (method.getName().startsWith("set")) {
                name = method.getName().substring(3);
                Preconditions.checkArgument((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (Object)"Expected setter to have one parameter");
                Preconditions.checkArgument((boolean)((Class)fieldTypes.get(name)).equals(method.getParameterTypes()[0]), (String)"Expected %s to accept type %s, but found %s", (Object)method.getName(), fieldTypes.get(name), method.getParameterTypes()[0]);
                Preconditions.checkArgument((StateCompiler.getInitialValue(method) == null ? 1 : 0) != 0, (Object)"initial value annotation not allowed on setter");
                Preconditions.checkArgument((boolean)method.getReturnType().equals(Void.TYPE), (String)"%s may not return a value", (Object)method.getName());
                setters.add(name);
                continue;
            }
            throw new IllegalArgumentException("Cannot generate implementation for method: " + method.getName());
        }
        Preconditions.checkArgument((getters.size() + isGetters.size() == setters.size() && setters.size() == fields.size() ? 1 : 0) != 0, (Object)"Wrong number of getters/setters");
    }

    private static final class StateField {
        private final String name;
        private final String getterName;
        private final Class<?> type;
        private final Object initialValue;
        private final Optional<Type> sqlType;

        private StateField(String name, Class<?> type, Object initialValue, String getterName, Optional<Type> sqlType) {
            this.name = Objects.requireNonNull(name, "name is null");
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"name is empty");
            this.type = Objects.requireNonNull(type, "type is null");
            this.getterName = Objects.requireNonNull(getterName, "getterName is null");
            this.initialValue = initialValue;
            Preconditions.checkArgument((sqlType != null ? 1 : 0) != 0, (Object)"sqlType is null");
            if (sqlType.isPresent()) {
                Preconditions.checkArgument((type.isAssignableFrom(sqlType.get().getJavaType()) || type == Byte.TYPE && TinyintType.TINYINT.equals((Object)sqlType.get()) || type == Integer.TYPE && IntegerType.INTEGER.equals((Object)sqlType.get()) ? 1 : 0) != 0, (String)"Stack type (%s) and provided sql type (%s) are incompatible", (Object)type.getName(), (Object)sqlType.get().getDisplayName());
            } else {
                sqlType = StateField.sqlTypeFromStackType(type);
            }
            this.sqlType = sqlType;
        }

        private static Optional<Type> sqlTypeFromStackType(Class<?> stackType) {
            if (stackType == Long.TYPE) {
                return Optional.of(BigintType.BIGINT);
            }
            if (stackType == Double.TYPE) {
                return Optional.of(DoubleType.DOUBLE);
            }
            if (stackType == Boolean.TYPE) {
                return Optional.of(BooleanType.BOOLEAN);
            }
            if (stackType == Byte.TYPE) {
                return Optional.of(TinyintType.TINYINT);
            }
            if (stackType == Integer.TYPE) {
                return Optional.of(IntegerType.INTEGER);
            }
            if (stackType == Slice.class) {
                return Optional.of(VarbinaryType.VARBINARY);
            }
            return Optional.empty();
        }

        String getGetterName() {
            return this.getterName;
        }

        String getSetterName() {
            return "set" + this.getName();
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getType() {
            return this.type;
        }

        Type getSqlType() {
            if (this.sqlType.isEmpty()) {
                throw new IllegalArgumentException("Unsupported type: " + this.type);
            }
            return this.sqlType.get();
        }

        boolean isPrimitiveType() {
            Class<?> type = this.getType();
            return type == Long.TYPE || type == Double.TYPE || type == Boolean.TYPE || type == Byte.TYPE || type == Integer.TYPE;
        }

        public BytecodeExpression initialValueExpression() {
            if (this.initialValue == null) {
                return BytecodeExpressions.defaultValue(this.type);
            }
            if (this.initialValue instanceof Number) {
                return BytecodeExpressions.constantNumber((Number)((Number)this.initialValue));
            }
            if (this.initialValue instanceof Boolean) {
                return BytecodeExpressions.constantBoolean((boolean)((Boolean)this.initialValue));
            }
            throw new IllegalArgumentException("Unsupported initial value type: " + this.initialValue.getClass());
        }
    }
}

