/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import io.prestosql.connector.CatalogName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.DiscretePredicates;
import io.prestosql.spi.connector.LocalProperty;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.sql.planner.PartitioningHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TableProperties {
    private final ConnectorTableProperties tableProperties;
    private final CatalogName catalogName;
    private final ConnectorTransactionHandle transaction;

    public TableProperties(CatalogName catalogName, ConnectorTransactionHandle transaction, ConnectorTableProperties tableProperties) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Objects.requireNonNull(transaction, "transaction is null");
        Objects.requireNonNull(tableProperties, "layout is null");
        this.catalogName = catalogName;
        this.transaction = transaction;
        this.tableProperties = tableProperties;
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.tableProperties.getPredicate();
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.tableProperties.getLocalProperties();
    }

    public Optional<TablePartitioning> getTablePartitioning() {
        return this.tableProperties.getTablePartitioning().map(nodePartitioning -> new TablePartitioning(new PartitioningHandle(Optional.of(this.catalogName), Optional.of(this.transaction), nodePartitioning.getPartitioningHandle()), nodePartitioning.getPartitioningColumns()));
    }

    public Optional<Set<ColumnHandle>> getStreamPartitioningColumns() {
        return this.tableProperties.getStreamPartitioningColumns();
    }

    public Optional<DiscretePredicates> getDiscretePredicates() {
        return this.tableProperties.getDiscretePredicates();
    }

    public static class TablePartitioning {
        private final PartitioningHandle partitioningHandle;
        private final List<ColumnHandle> partitioningColumns;

        public TablePartitioning(PartitioningHandle partitioningHandle, List<ColumnHandle> partitioningColumns) {
            this.partitioningHandle = Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
            this.partitioningColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle;
        }

        public List<ColumnHandle> getPartitioningColumns() {
            return this.partitioningColumns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TablePartitioning that = (TablePartitioning)o;
            return Objects.equals(this.partitioningHandle, that.partitioningHandle) && Objects.equals(this.partitioningColumns, that.partitioningColumns);
        }

        public int hashCode() {
            return Objects.hash(this.partitioningHandle, this.partitioningColumns);
        }
    }
}

