/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.prestosql.Session;
import io.prestosql.connector.CatalogName;
import io.prestosql.metadata.AggregationFunctionMetadata;
import io.prestosql.metadata.AnalyzePropertyManager;
import io.prestosql.metadata.AnalyzeTableHandle;
import io.prestosql.metadata.CatalogManager;
import io.prestosql.metadata.CatalogMetadata;
import io.prestosql.metadata.ColumnPropertyManager;
import io.prestosql.metadata.FunctionArgumentDefinition;
import io.prestosql.metadata.FunctionId;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.FunctionKind;
import io.prestosql.metadata.FunctionMetadata;
import io.prestosql.metadata.FunctionRegistry;
import io.prestosql.metadata.FunctionResolver;
import io.prestosql.metadata.InsertTableHandle;
import io.prestosql.metadata.InternalBlockEncodingSerde;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.NewTableLayout;
import io.prestosql.metadata.OperatorNotFoundException;
import io.prestosql.metadata.OutputTableHandle;
import io.prestosql.metadata.ProcedureRegistry;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.metadata.ResolvedFunction;
import io.prestosql.metadata.ResolvedIndex;
import io.prestosql.metadata.SchemaPropertyManager;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.metadata.Signature;
import io.prestosql.metadata.SqlFunction;
import io.prestosql.metadata.TableHandle;
import io.prestosql.metadata.TableLayoutResult;
import io.prestosql.metadata.TableMetadata;
import io.prestosql.metadata.TableProperties;
import io.prestosql.metadata.TablePropertyManager;
import io.prestosql.metadata.TypeRegistry;
import io.prestosql.operator.aggregation.InternalAggregationFunction;
import io.prestosql.operator.window.WindowFunctionSupplier;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.block.ArrayBlockEncoding;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.block.ByteArrayBlockEncoding;
import io.prestosql.spi.block.DictionaryBlockEncoding;
import io.prestosql.spi.block.Int128ArrayBlockEncoding;
import io.prestosql.spi.block.Int96ArrayBlockEncoding;
import io.prestosql.spi.block.IntArrayBlockEncoding;
import io.prestosql.spi.block.LazyBlockEncoding;
import io.prestosql.spi.block.LongArrayBlockEncoding;
import io.prestosql.spi.block.MapBlockEncoding;
import io.prestosql.spi.block.RowBlockEncoding;
import io.prestosql.spi.block.RunLengthBlockEncoding;
import io.prestosql.spi.block.ShortArrayBlockEncoding;
import io.prestosql.spi.block.SingleMapBlockEncoding;
import io.prestosql.spi.block.SingleRowBlockEncoding;
import io.prestosql.spi.block.VariableWidthBlockEncoding;
import io.prestosql.spi.connector.AggregateFunction;
import io.prestosql.spi.connector.AggregationApplicationResult;
import io.prestosql.spi.connector.Assignment;
import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorCapabilities;
import io.prestosql.spi.connector.ConnectorInsertTableHandle;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorNewTableLayout;
import io.prestosql.spi.connector.ConnectorOutputMetadata;
import io.prestosql.spi.connector.ConnectorOutputTableHandle;
import io.prestosql.spi.connector.ConnectorPartitioningHandle;
import io.prestosql.spi.connector.ConnectorResolvedIndex;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableLayout;
import io.prestosql.spi.connector.ConnectorTableLayoutHandle;
import io.prestosql.spi.connector.ConnectorTableLayoutResult;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.LimitApplicationResult;
import io.prestosql.spi.connector.ProjectionApplicationResult;
import io.prestosql.spi.connector.SampleType;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SystemTable;
import io.prestosql.spi.expression.ConnectorExpression;
import io.prestosql.spi.expression.Variable;
import io.prestosql.spi.function.InvocationConvention;
import io.prestosql.spi.function.OperatorType;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.security.GrantInfo;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.RoleGrant;
import io.prestosql.spi.statistics.ComputedStatistics;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.statistics.TableStatisticsMetadata;
import io.prestosql.spi.type.BigintType;
import io.prestosql.spi.type.BooleanType;
import io.prestosql.spi.type.ParametricType;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.TypeId;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.TypeNotFoundException;
import io.prestosql.spi.type.TypeSignature;
import io.prestosql.sql.analyzer.FeaturesConfig;
import io.prestosql.sql.analyzer.TypeSignatureProvider;
import io.prestosql.sql.planner.ConnectorExpressions;
import io.prestosql.sql.planner.PartitioningHandle;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.transaction.InMemoryTransactionManager;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.type.InternalTypeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public final class MetadataManager
implements Metadata {
    private final FunctionRegistry functions;
    private final FunctionResolver functionResolver;
    private final ProcedureRegistry procedures;
    private final SessionPropertyManager sessionPropertyManager;
    private final SchemaPropertyManager schemaPropertyManager;
    private final TablePropertyManager tablePropertyManager;
    private final ColumnPropertyManager columnPropertyManager;
    private final AnalyzePropertyManager analyzePropertyManager;
    private final TransactionManager transactionManager;
    private final TypeRegistry typeRegistry;
    private final ConcurrentMap<String, BlockEncoding> blockEncodings = new ConcurrentHashMap<String, BlockEncoding>();
    private final ConcurrentMap<QueryId, QueryCatalogs> catalogsByQueryId = new ConcurrentHashMap<QueryId, QueryCatalogs>();

    @Inject
    public MetadataManager(FeaturesConfig featuresConfig, SessionPropertyManager sessionPropertyManager, SchemaPropertyManager schemaPropertyManager, TablePropertyManager tablePropertyManager, ColumnPropertyManager columnPropertyManager, AnalyzePropertyManager analyzePropertyManager, TransactionManager transactionManager) {
        this.typeRegistry = new TypeRegistry(featuresConfig);
        this.functions = new FunctionRegistry(this, featuresConfig);
        this.functionResolver = new FunctionResolver(this);
        this.procedures = new ProcedureRegistry(this);
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.schemaPropertyManager = Objects.requireNonNull(schemaPropertyManager, "schemaPropertyManager is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.columnPropertyManager = Objects.requireNonNull(columnPropertyManager, "columnPropertyManager is null");
        this.analyzePropertyManager = Objects.requireNonNull(analyzePropertyManager, "analyzePropertyManager is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.addBlockEncoding((BlockEncoding)new VariableWidthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ByteArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ShortArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new IntArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LongArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Int96ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new Int128ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new DictionaryBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new ArrayBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new MapBlockEncoding((TypeManager)new InternalTypeManager(this)));
        this.addBlockEncoding((BlockEncoding)new SingleMapBlockEncoding((TypeManager)new InternalTypeManager(this)));
        this.addBlockEncoding((BlockEncoding)new RowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new SingleRowBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new RunLengthBlockEncoding());
        this.addBlockEncoding((BlockEncoding)new LazyBlockEncoding());
        this.verifyComparableOrderableContract();
    }

    public static MetadataManager createTestMetadataManager() {
        return MetadataManager.createTestMetadataManager(new FeaturesConfig());
    }

    public static MetadataManager createTestMetadataManager(FeaturesConfig featuresConfig) {
        return MetadataManager.createTestMetadataManager(new CatalogManager(), featuresConfig);
    }

    public static MetadataManager createTestMetadataManager(CatalogManager catalogManager) {
        return MetadataManager.createTestMetadataManager(catalogManager, new FeaturesConfig());
    }

    public static MetadataManager createTestMetadataManager(CatalogManager catalogManager, FeaturesConfig featuresConfig) {
        return MetadataManager.createTestMetadataManager(InMemoryTransactionManager.createTestTransactionManager(catalogManager), featuresConfig);
    }

    public static MetadataManager createTestMetadataManager(TransactionManager transactionManager, FeaturesConfig featuresConfig) {
        return new MetadataManager(featuresConfig, new SessionPropertyManager(), new SchemaPropertyManager(), new TablePropertyManager(), new ColumnPropertyManager(), new AnalyzePropertyManager(), transactionManager);
    }

    @Override
    public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogName catalogName) {
        return this.getCatalogMetadata(session, catalogName).getConnectorCapabilities();
    }

    @Override
    public boolean catalogExists(Session session, String catalogName) {
        return this.getOptionalCatalogMetadata(session, catalogName).isPresent();
    }

    private boolean canResolveOperator(OperatorType operatorType, Type returnType, List<? extends Type> argumentTypes) {
        FunctionId functionId = FunctionId.toFunctionId(new Signature(Signature.mangleOperatorName(operatorType), returnType.getTypeSignature(), (List)argumentTypes.stream().map(Type::getTypeSignature).collect(ImmutableList.toImmutableList())));
        try {
            this.functions.get(functionId);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, schema.getCatalogName());
        if (catalog.isEmpty()) {
            return false;
        }
        CatalogMetadata catalogMetadata = catalog.get();
        ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
        return catalogMetadata.listConnectorIds().stream().map(catalogMetadata::getMetadataFor).anyMatch(metadata -> metadata.schemaExists(connectorSession, schema.getSchemaName()));
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, catalogName);
        ImmutableSet.Builder schemaNames = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
            for (CatalogName connectorId : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(connectorId);
                metadata.listSchemaNames(connectorSession).stream().map(schema -> schema.toLowerCase(Locale.ENGLISH)).forEach(arg_0 -> ((ImmutableSet.Builder)schemaNames).add(arg_0));
            }
        }
        return ImmutableList.copyOf((Collection)schemaNames.build());
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName table) {
        ConnectorSession connectorSession;
        CatalogName catalogName;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        if (table.getCatalogName().isEmpty() || table.getSchemaName().isEmpty() || table.getObjectName().isEmpty()) {
            return Optional.empty();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, table.getCatalogName());
        if (catalog.isPresent() && (tableHandle = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(catalogName = catalogMetadata.getConnectorId(session, table))).getTableHandle(connectorSession = session.toConnectorSession(catalogName), table.asSchemaTableName())) != null) {
            return Optional.of(new TableHandle(catalogName, tableHandle, catalogMetadata.getTransactionHandleFor(catalogName), Optional.empty()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<TableHandle> getTableHandleForStatisticsCollection(Session session, QualifiedObjectName table, Map<String, Object> analyzeProperties) {
        CatalogName catalogName;
        CatalogMetadata catalogMetadata;
        ConnectorMetadata metadata;
        ConnectorTableHandle tableHandle;
        Objects.requireNonNull(table, "table is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, table.getCatalogName());
        if (catalog.isPresent() && (tableHandle = (metadata = (catalogMetadata = catalog.get()).getMetadataFor(catalogName = catalogMetadata.getConnectorId(session, table))).getTableHandleForStatisticsCollection(session.toConnectorSession(catalogName), table.asSchemaTableName(), analyzeProperties)) != null) {
            return Optional.of(new TableHandle(catalogName, tableHandle, catalogMetadata.getTransactionHandleFor(catalogName), Optional.empty()));
        }
        return Optional.empty();
    }

    @Override
    public Optional<SystemTable> getSystemTable(Session session, QualifiedObjectName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "table is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, tableName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getCatalogName();
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
            return metadata.getSystemTable(session.toConnectorSession(catalogName), tableName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public Optional<TableLayoutResult> getLayout(Session session, TableHandle table, Constraint constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        if (constraint.getSummary().isNone()) {
            return Optional.empty();
        }
        CatalogName catalogName = table.getCatalogName();
        ConnectorTableHandle connectorTable = table.getConnectorHandle();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        Preconditions.checkState((boolean)metadata.usesLegacyTableLayouts(), (Object)"getLayout() was called even though connector doesn't support legacy Table Layout");
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        List layouts = metadata.getTableLayouts(connectorSession, connectorTable, constraint, desiredColumns);
        if (layouts.isEmpty()) {
            return Optional.empty();
        }
        if (layouts.size() > 1) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Connector returned multiple layouts for table %s", table));
        }
        ConnectorTableLayout tableLayout = ((ConnectorTableLayoutResult)layouts.get(0)).getTableLayout();
        return Optional.of(new TableLayoutResult(new TableHandle(catalogName, connectorTable, transaction, Optional.of(tableLayout.getHandle())), new TableProperties(catalogName, transaction, new ConnectorTableProperties(tableLayout)), (TupleDomain<ColumnHandle>)((ConnectorTableLayoutResult)layouts.get(0)).getUnenforcedConstraint()));
    }

    @Override
    public TableProperties getTableProperties(Session session, TableHandle handle) {
        CatalogName catalogName = handle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return handle.getLayout().map(layout -> new TableProperties(catalogName, handle.getTransaction(), new ConnectorTableProperties(metadata.getTableLayout(connectorSession, layout)))).orElseGet(() -> this.getLayout(session, handle, Constraint.alwaysTrue(), Optional.empty()).get().getTableProperties());
        }
        return new TableProperties(catalogName, handle.getTransaction(), metadata.getTableProperties(connectorSession, handle.getConnectorHandle()));
    }

    @Override
    public TableHandle makeCompatiblePartitioning(Session session, TableHandle tableHandle, PartitioningHandle partitioningHandle) {
        Preconditions.checkArgument((boolean)partitioningHandle.getConnectorId().isPresent(), (Object)"Expect partitioning handle from connector, got system partitioning handle");
        CatalogName catalogName = partitioningHandle.getConnectorId().get();
        Preconditions.checkArgument((boolean)catalogName.equals(tableHandle.getCatalogName()), (Object)"ConnectorId of tableHandle and partitioningHandle does not match");
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            ConnectorTableLayoutHandle newTableLayoutHandle = metadata.makeCompatiblePartitioning(session.toConnectorSession(catalogName), tableHandle.getLayout().get(), partitioningHandle.getConnectorHandle());
            return new TableHandle(catalogName, tableHandle.getConnectorHandle(), transaction, Optional.of(newTableLayoutHandle));
        }
        Verify.verify((boolean)tableHandle.getLayout().isEmpty(), (String)"layout should not be present", (Object[])new Object[0]);
        ConnectorTableHandle newTableHandle = metadata.makeCompatiblePartitioning(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), partitioningHandle.getConnectorHandle());
        return new TableHandle(catalogName, newTableHandle, transaction, Optional.empty());
    }

    @Override
    public Optional<PartitioningHandle> getCommonPartitioning(Session session, PartitioningHandle left, PartitioningHandle right) {
        Optional<CatalogName> leftConnectorId = left.getConnectorId();
        Optional<CatalogName> rightConnectorId = right.getConnectorId();
        if (leftConnectorId.isEmpty() || rightConnectorId.isEmpty() || !leftConnectorId.equals(rightConnectorId)) {
            return Optional.empty();
        }
        if (!left.getTransactionHandle().equals(right.getTransactionHandle())) {
            return Optional.empty();
        }
        CatalogName catalogName = leftConnectorId.get();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        Optional commonHandle = metadata.getCommonPartitioningHandle(session.toConnectorSession(catalogName), left.getConnectorHandle(), right.getConnectorHandle());
        return commonHandle.map(handle -> new PartitioningHandle(Optional.of(catalogName), left.getTransactionHandle(), (ConnectorPartitioningHandle)handle));
    }

    @Override
    public Optional<Object> getInfo(Session session, TableHandle handle) {
        CatalogName catalogName = handle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (this.usesLegacyTableLayouts(session, handle)) {
            ConnectorTableLayoutHandle layoutHandle = handle.getLayout().orElseGet(() -> this.getLayout(session, handle, Constraint.alwaysTrue(), Optional.empty()).get().getNewTableHandle().getLayout().get());
            return metadata.getInfo(layoutHandle);
        }
        return metadata.getInfo(handle.getConnectorHandle());
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        ConnectorTableMetadata tableMetadata = metadata.getTableMetadata(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new TableMetadata(catalogName, tableMetadata);
    }

    @Override
    public TableStatistics getTableStatistics(Session session, TableHandle tableHandle, Constraint constraint) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getTableStatistics(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), constraint);
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        Map handles = metadata.getColumnHandles(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Map.Entry mapEntry : handles.entrySet()) {
            map.put((Object)((String)mapEntry.getKey()).toLowerCase(Locale.ENGLISH), (Object)((ColumnHandle)mapEntry.getValue()));
        }
        return map.build();
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getColumnMetadata(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), columnHandle);
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            return (List)this.getTableHandle(session, objectName.get()).map(handle -> ImmutableList.of((Object)((QualifiedObjectName)objectName.get()))).orElseGet(ImmutableList::of);
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet tables = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                metadata.listTables(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(tables::add);
            }
        }
        return ImmutableList.copyOf(tables);
    }

    @Override
    public Map<QualifiedObjectName, List<ColumnMetadata>> listTableColumns(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        HashMap tableColumns = new HashMap();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                for (Map.Entry entry : metadata.listTableColumns(connectorSession, tablePrefix).entrySet()) {
                    QualifiedObjectName tableName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    tableColumns.put(tableName, (List)entry.getValue());
                }
                for (Map.Entry<Object, Object> entry : this.getViews(session, prefix).entrySet()) {
                    ImmutableList.Builder columns = ImmutableList.builder();
                    for (ConnectorViewDefinition.ViewColumn column : ((ConnectorViewDefinition)entry.getValue()).getColumns()) {
                        try {
                            columns.add((Object)new ColumnMetadata(column.getName(), this.getType(column.getType())));
                        }
                        catch (TypeNotFoundException e) {
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_VIEW, String.format("Unknown type '%s' for column '%s' in view: %s", column.getType(), column.getName(), entry.getKey()));
                        }
                    }
                    tableColumns.put((QualifiedObjectName)entry.getKey(), columns.build());
                }
            }
        }
        return ImmutableMap.copyOf(tableColumns);
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, PrestoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createSchema(session.toConnectorSession(catalogName), schema.getSchemaName(), properties, principal);
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, schema.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropSchema(session.toConnectorSession(catalogName), schema.getSchemaName());
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.renameSchema(session.toConnectorSession(catalogName), source.getSchemaName(), target);
    }

    @Override
    public void setSchemaAuthorization(Session session, CatalogSchemaName source, PrestoPrincipal principal) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, source.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.setSchemaAuthorization(session.toConnectorSession(catalogName), source.getSchemaName(), principal);
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createTable(session.toConnectorSession(catalog), tableMetadata, ignoreExisting);
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, QualifiedObjectName newTableName) {
        String catalogName = newTableName.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        if (!tableHandle.getCatalogName().equals(catalog)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename tables across catalogs");
        }
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.renameTable(session.toConnectorSession(catalog), tableHandle.getConnectorHandle(), newTableName.asSchemaTableName());
    }

    @Override
    public void setTableComment(Session session, TableHandle tableHandle, Optional<String> comment) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.setTableComment(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), comment);
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, ColumnHandle source, String target) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.renameColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), source, target.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, ColumnMetadata column) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.addColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropColumn(Session session, TableHandle tableHandle, ColumnHandle column) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.dropColumn(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), column);
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        metadata.dropTable(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
    }

    @Override
    public Optional<NewTableLayout> getInsertLayout(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        return metadata.getInsertLayout(session.toConnectorSession(catalogName), table.getConnectorHandle()).map(layout -> new NewTableLayout(catalogName, catalogMetadata.getTransactionHandleFor(catalogName), (ConnectorNewTableLayout)layout));
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        CatalogName catalog = catalogMetadata.getCatalogName();
        return metadata.getStatisticsCollectionMetadataForWrite(session.toConnectorSession(catalog), tableMetadata);
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadata(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        CatalogName catalog = catalogMetadata.getCatalogName();
        return metadata.getStatisticsCollectionMetadata(session.toConnectorSession(catalog), tableMetadata);
    }

    @Override
    public AnalyzeTableHandle beginStatisticsCollection(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorTableHandle connectorTableHandle = metadata.beginStatisticsCollection(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new AnalyzeTableHandle(catalogName, transactionHandle, connectorTableHandle);
    }

    @Override
    public void finishStatisticsCollection(Session session, AnalyzeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        catalogMetadata.getMetadata().finishStatisticsCollection(session.toConnectorSession(), tableHandle.getConnectorHandle(), computedStatistics);
    }

    @Override
    public Optional<NewTableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalog);
        ConnectorSession connectorSession = session.toConnectorSession(catalog);
        return metadata.getNewTableLayout(connectorSession, tableMetadata).map(layout -> new NewTableLayout(catalog, transactionHandle, (ConnectorNewTableLayout)layout));
    }

    @Override
    public void cleanupQuery(Session session) {
        QueryCatalogs queryCatalogs = (QueryCatalogs)this.catalogsByQueryId.remove(session.getQueryId());
        if (queryCatalogs != null) {
            queryCatalogs.finish();
        }
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<NewTableLayout> layout) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        CatalogName catalog = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalog);
        ConnectorSession connectorSession = session.toConnectorSession(catalog);
        ConnectorOutputTableHandle handle = metadata.beginCreateTable(connectorSession, tableMetadata, layout.map(NewTableLayout::getLayout));
        return new OutputTableHandle(catalog, transactionHandle, handle);
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.finishCreateTable(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle, List<ColumnHandle> columns) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        ConnectorTransactionHandle transactionHandle = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorInsertTableHandle handle = metadata.beginInsert(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), columns);
        return new InsertTableHandle(tableHandle.getCatalogName(), transactionHandle, handle);
    }

    @Override
    public boolean supportsMissingColumnsOnInsert(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        return catalogMetadata.getMetadata().supportsMissingColumnsOnInsert();
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.finishInsert(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments, computedStatistics);
    }

    @Override
    public ColumnHandle getUpdateRowIdColumnHandle(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        return metadata.getUpdateRowIdColumnHandle(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
    }

    @Override
    public boolean supportsMetadataDelete(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (!metadata.usesLegacyTableLayouts()) {
            return false;
        }
        return metadata.supportsMetadataDelete(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), tableHandle.getLayout().get());
    }

    @Override
    public Optional<TableHandle> applyDelete(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyDelete(connectorSession, table.getConnectorHandle()).map(newHandle -> new TableHandle(catalogName, (ConnectorTableHandle)newHandle, table.getTransaction(), Optional.empty()));
    }

    @Override
    public OptionalLong executeDelete(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            Preconditions.checkArgument((boolean)table.getLayout().isPresent(), (Object)"table layout is missing");
            return metadata.metadataDelete(session.toConnectorSession(catalogName), table.getConnectorHandle(), table.getLayout().get());
        }
        Preconditions.checkArgument((boolean)table.getLayout().isEmpty(), (Object)"table layout should not be present");
        return metadata.executeDelete(connectorSession, table.getConnectorHandle());
    }

    @Override
    public TableHandle beginDelete(Session session, TableHandle tableHandle) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadataForWrite(session, catalogName);
        ConnectorTableHandle newHandle = metadata.beginDelete(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle());
        return new TableHandle(tableHandle.getCatalogName(), newHandle, tableHandle.getTransaction(), tableHandle.getLayout());
    }

    @Override
    public void finishDelete(Session session, TableHandle tableHandle, Collection<Slice> fragments) {
        CatalogName catalogName = tableHandle.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.finishDelete(session.toConnectorSession(catalogName), tableHandle.getConnectorHandle(), fragments);
    }

    @Override
    public Optional<CatalogName> getCatalogHandle(Session session, String catalogName) {
        return this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName).map(CatalogMetadata::getCatalogName);
    }

    @Override
    public Map<String, CatalogName> getCatalogNames(Session session) {
        return this.transactionManager.getCatalogNames(session.getRequiredTransactionId());
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<QualifiedObjectName> objectName = prefix.asQualifiedObjectName();
        if (objectName.isPresent()) {
            return (List)this.getView(session, objectName.get()).map(handle -> ImmutableList.of((Object)((QualifiedObjectName)objectName.get()))).orElseGet(ImmutableList::of);
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashSet views = new LinkedHashSet();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                metadata.listViews(connectorSession, prefix.getSchemaName()).stream().map(QualifiedObjectName.convertFromSchemaTableName(prefix.getCatalogName())).filter(prefix::matches).forEach(views::add);
            }
        }
        return ImmutableList.copyOf(views);
    }

    @Override
    public Map<QualifiedObjectName, ConnectorViewDefinition> getViews(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        LinkedHashMap<QualifiedObjectName, ConnectorViewDefinition> views = new LinkedHashMap<QualifiedObjectName, ConnectorViewDefinition>();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            SchemaTablePrefix tablePrefix = prefix.asSchemaTablePrefix();
            for (CatalogName catalogName : catalogMetadata.listConnectorIds()) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                ConnectorSession connectorSession = session.toConnectorSession(catalogName);
                Map viewMap = tablePrefix.getTable().isPresent() ? (Map)metadata.getView(connectorSession, tablePrefix.toSchemaTableName()).map(view -> ImmutableMap.of((Object)tablePrefix.toSchemaTableName(), (Object)view)).orElse(ImmutableMap.of()) : metadata.getViews(connectorSession, tablePrefix.getSchema());
                for (Map.Entry entry : viewMap.entrySet()) {
                    QualifiedObjectName viewName = new QualifiedObjectName(prefix.getCatalogName(), ((SchemaTableName)entry.getKey()).getSchemaName(), ((SchemaTableName)entry.getKey()).getTableName());
                    views.put(viewName, (ConnectorViewDefinition)entry.getValue());
                }
            }
        }
        return ImmutableMap.copyOf(views);
    }

    @Override
    public Map<String, Object> getSchemaProperties(Session session, CatalogSchemaName schemaName) {
        if (!this.schemaExists(session, schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, new CatalogName(schemaName.getCatalogName()));
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.getSchemaProperties(connectorSession, schemaName);
    }

    @Override
    public Optional<PrestoPrincipal> getSchemaOwner(Session session, CatalogSchemaName schemaName) {
        if (!this.schemaExists(session, schemaName)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, String.format("Schema '%s' does not exist", schemaName));
        }
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, new CatalogName(schemaName.getCatalogName()));
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.getSchemaOwner(connectorSession, schemaName);
    }

    @Override
    public Optional<ConnectorViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        if (viewName.getCatalogName().isEmpty() || viewName.getSchemaName().isEmpty() || viewName.getObjectName().isEmpty()) {
            return Optional.empty();
        }
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, viewName.getCatalogName());
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            CatalogName catalogName = catalogMetadata.getConnectorId(session, viewName);
            ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
            ConnectorSession connectorSession = session.toConnectorSession(catalogName);
            return metadata.getView(connectorSession, viewName.asSchemaTableName());
        }
        return Optional.empty();
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, ConnectorViewDefinition definition, boolean replace) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createView(session.toConnectorSession(catalogName), viewName.asSchemaTableName(), definition, replace);
    }

    @Override
    public void renameView(Session session, QualifiedObjectName source, QualifiedObjectName target) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, target.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        if (!source.getCatalogName().equals(catalogName.getCatalogName())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SYNTAX_ERROR, "Cannot rename views across catalogs");
        }
        metadata.renameView(session.toConnectorSession(catalogName), source.asSchemaTableName(), target.asSchemaTableName());
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, viewName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropView(session.toConnectorSession(catalogName), viewName.asSchemaTableName());
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        CatalogName catalogName = tableHandle.getCatalogName();
        CatalogMetadata catalogMetadata = this.getCatalogMetadata(session, catalogName);
        ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
        ConnectorTransactionHandle transaction = catalogMetadata.getTransactionHandleFor(catalogName);
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        Optional resolvedIndex = metadata.resolveIndex(connectorSession, tableHandle.getConnectorHandle(), indexableColumns, outputColumns, tupleDomain);
        return resolvedIndex.map(resolved -> new ResolvedIndex(tableHandle.getCatalogName(), transaction, (ConnectorResolvedIndex)resolved));
    }

    @Override
    public boolean usesLegacyTableLayouts(Session session, TableHandle table) {
        return this.getMetadata(session, table.getCatalogName()).usesLegacyTableLayouts();
    }

    @Override
    public Optional<LimitApplicationResult<TableHandle>> applyLimit(Session session, TableHandle table, long limit) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyLimit(connectorSession, table.getConnectorHandle(), limit).map(result -> new LimitApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.isLimitGuaranteed()));
    }

    @Override
    public Optional<TableHandle> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applySample(connectorSession, table.getConnectorHandle(), sampleType, sampleRatio).map(result -> new TableHandle(catalogName, (ConnectorTableHandle)result, table.getTransaction(), Optional.empty()));
    }

    @Override
    public Optional<AggregationApplicationResult<TableHandle>> applyAggregation(Session session, TableHandle table, List<AggregateFunction> aggregations, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        Preconditions.checkArgument((!groupingSets.isEmpty() ? 1 : 0) != 0, (Object)"No grouping sets provided");
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyAggregation(connectorSession, table.getConnectorHandle(), aggregations, assignments, groupingSets).map(result -> {
            this.verifyProjection(table, result.getProjections(), result.getAssignments(), aggregations.size());
            return new AggregationApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.getProjections(), result.getAssignments(), result.getGroupingColumnMapping());
        });
    }

    private void verifyProjection(TableHandle table, List<ConnectorExpression> projections, List<Assignment> assignments, int expectedProjectionSize) {
        projections.forEach(projection -> Objects.requireNonNull(projection, "one of the projections is null"));
        assignments.forEach(assignment -> Objects.requireNonNull(assignment, "one of the assignments is null"));
        Verify.verify((expectedProjectionSize == projections.size() ? 1 : 0) != 0, (String)"ConnectorMetadata returned invalid number of projections: %s instead of %s for %s", (Object)projections.size(), (Object)expectedProjectionSize, (Object)table);
        Set assignedVariables = (Set)assignments.stream().map(Assignment::getVariable).collect(ImmutableSet.toImmutableSet());
        projections.stream().flatMap(connectorExpression -> ConnectorExpressions.extractVariables(connectorExpression).stream()).map(Variable::getName).filter(variableName -> !assignedVariables.contains(variableName)).findAny().ifPresent(variableName -> {
            throw new IllegalStateException("Unbound variable: " + variableName);
        });
    }

    @Override
    public void validateScan(Session session, TableHandle table) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        metadata.validateScan(session.toConnectorSession(catalogName), table.getConnectorHandle());
    }

    @Override
    public Optional<ConstraintApplicationResult<TableHandle>> applyFilter(Session session, TableHandle table, Constraint constraint) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyFilter(connectorSession, table.getConnectorHandle(), constraint).map(result -> new ConstraintApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.getRemainingFilter()));
    }

    @Override
    public Optional<ProjectionApplicationResult<TableHandle>> applyProjection(Session session, TableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        CatalogName catalogName = table.getCatalogName();
        ConnectorMetadata metadata = this.getMetadata(session, catalogName);
        if (metadata.usesLegacyTableLayouts()) {
            return Optional.empty();
        }
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        return metadata.applyProjection(connectorSession, table.getConnectorHandle(), projections, assignments).map(result -> {
            this.verifyProjection(table, result.getProjections(), result.getAssignments(), projections.size());
            return new ProjectionApplicationResult((Object)new TableHandle(catalogName, (ConnectorTableHandle)result.getHandle(), table.getTransaction(), Optional.empty()), result.getProjections(), result.getAssignments());
        });
    }

    @Override
    public void createRole(Session session, String role, Optional<PrestoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.createRole(session.toConnectorSession(catalogName), role, grantor);
    }

    @Override
    public void dropRole(Session session, String role, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.dropRole(session.toConnectorSession(catalogName), role);
    }

    @Override
    public Set<String> listRoles(Session session, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return (Set)metadata.listRoles(connectorSession).stream().map(role -> role.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<RoleGrant> listAllRoleGrants(Session session, String catalog, Optional<Set<String>> roles, Optional<Set<String>> grantees, OptionalLong limit) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (!catalogMetadata.isPresent()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return metadata.listAllRoleGrants(connectorSession, roles, grantees, limit);
    }

    @Override
    public Set<RoleGrant> listRoleGrants(Session session, String catalog, PrestoPrincipal principal) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return metadata.listRoleGrants(connectorSession, principal);
    }

    @Override
    public void grantRoles(Session session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.grantRoles(session.toConnectorSession(catalogName), roles, grantees, adminOption, grantor);
    }

    @Override
    public void revokeRoles(Session session, Set<String> roles, Set<PrestoPrincipal> grantees, boolean adminOption, Optional<PrestoPrincipal> grantor, String catalog) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, catalog);
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.revokeRoles(session.toConnectorSession(catalogName), roles, grantees, adminOption, grantor);
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(Session session, PrestoPrincipal principal, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return ImmutableSet.copyOf((Collection)metadata.listApplicableRoles(connectorSession, principal));
    }

    @Override
    public Set<String> listEnabledRoles(Session session, String catalog) {
        Optional<CatalogMetadata> catalogMetadata = this.getOptionalCatalogMetadata(session, catalog);
        if (catalogMetadata.isEmpty()) {
            return ImmutableSet.of();
        }
        CatalogName catalogName = catalogMetadata.get().getCatalogName();
        ConnectorSession connectorSession = session.toConnectorSession(catalogName);
        ConnectorMetadata metadata = catalogMetadata.get().getMetadataFor(catalogName);
        return ImmutableSet.copyOf((Collection)metadata.listEnabledRoles(connectorSession));
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.grantTablePrivileges(session.toConnectorSession(catalogName), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, PrestoPrincipal grantee, boolean grantOption) {
        CatalogMetadata catalogMetadata = this.getCatalogMetadataForWrite(session, tableName.getCatalogName());
        CatalogName catalogName = catalogMetadata.getCatalogName();
        ConnectorMetadata metadata = catalogMetadata.getMetadata();
        metadata.revokeTablePrivileges(session.toConnectorSession(catalogName), tableName.asSchemaTableName(), privileges, grantee, grantOption);
    }

    @Override
    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        Optional<CatalogMetadata> catalog = this.getOptionalCatalogMetadata(session, prefix.getCatalogName());
        ImmutableSet.Builder grantInfos = ImmutableSet.builder();
        if (catalog.isPresent()) {
            CatalogMetadata catalogMetadata = catalog.get();
            ConnectorSession connectorSession = session.toConnectorSession(catalogMetadata.getCatalogName());
            List connectorIds = prefix.asQualifiedObjectName().map(qualifiedTableName -> Collections.singletonList(catalogMetadata.getConnectorId(session, (QualifiedObjectName)qualifiedTableName))).orElseGet(catalogMetadata::listConnectorIds);
            for (CatalogName catalogName : connectorIds) {
                ConnectorMetadata metadata = catalogMetadata.getMetadataFor(catalogName);
                grantInfos.addAll((Iterable)metadata.listTablePrivileges(connectorSession, prefix.asSchemaTablePrefix()));
            }
        }
        return ImmutableList.copyOf((Collection)grantInfos.build());
    }

    @Override
    public Type getType(TypeSignature signature) {
        return this.typeRegistry.getType((TypeManager)new InternalTypeManager(this), signature);
    }

    @Override
    public Type fromSqlType(String sqlType) {
        return this.typeRegistry.fromSqlType(new InternalTypeManager(this), sqlType);
    }

    @Override
    public Type getType(TypeId id) {
        return this.typeRegistry.getType((TypeManager)new InternalTypeManager(this), id);
    }

    @Override
    public Collection<Type> getTypes() {
        return this.typeRegistry.getTypes();
    }

    @Override
    public Collection<ParametricType> getParametricTypes() {
        return this.typeRegistry.getParametricTypes();
    }

    public void addType(Type type) {
        this.typeRegistry.addType(type);
    }

    public void addParametricType(ParametricType parametricType) {
        this.typeRegistry.addParametricType(parametricType);
    }

    @Override
    public void verifyComparableOrderableContract() {
        HashMultimap missingOperators = HashMultimap.create();
        for (Type type : this.typeRegistry.getTypes()) {
            if (type.isComparable()) {
                for (OperatorType operator : ImmutableList.of((Object)OperatorType.HASH_CODE, (Object)OperatorType.XX_HASH_64)) {
                    if (this.canResolveOperator(operator, (Type)BigintType.BIGINT, (List<? extends Type>)ImmutableList.of((Object)type))) continue;
                    missingOperators.put((Object)type, (Object)operator);
                }
                for (OperatorType operator : ImmutableList.of((Object)OperatorType.INDETERMINATE)) {
                    if (this.canResolveOperator(operator, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type))) continue;
                    missingOperators.put((Object)type, (Object)operator);
                }
                for (OperatorType operator : ImmutableList.of((Object)OperatorType.EQUAL, (Object)OperatorType.NOT_EQUAL, (Object)OperatorType.IS_DISTINCT_FROM)) {
                    if (this.canResolveOperator(operator, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) continue;
                    missingOperators.put((Object)type, (Object)operator);
                }
            }
            if (!type.isOrderable()) continue;
            for (OperatorType operator : ImmutableList.of((Object)OperatorType.LESS_THAN, (Object)OperatorType.LESS_THAN_OR_EQUAL, (Object)OperatorType.GREATER_THAN, (Object)OperatorType.GREATER_THAN_OR_EQUAL)) {
                if (this.canResolveOperator(operator, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)type, (Object)type))) continue;
                missingOperators.put((Object)type, (Object)operator);
            }
        }
        if (!missingOperators.isEmpty()) {
            ArrayList<String> messages = new ArrayList<String>();
            for (Type type : missingOperators.keySet()) {
                messages.add(String.format("%s missing for %s", missingOperators.get((Object)type), type));
            }
            throw new IllegalStateException(Joiner.on((String)", ").join(messages));
        }
    }

    @Override
    public void addFunctions(List<? extends SqlFunction> functionInfos) {
        this.functions.addFunctions(functionInfos);
    }

    @Override
    public List<FunctionMetadata> listFunctions() {
        return this.functions.list();
    }

    @Override
    public ResolvedFunction resolveFunction(QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        return ResolvedFunction.fromQualifiedName(name).orElseGet(() -> this.functionResolver.resolveFunction(this.functions.get(name), name, parameterTypes));
    }

    @Override
    public ResolvedFunction resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        try {
            return this.resolveFunction(QualifiedName.of((String)Signature.mangleOperatorName(operatorType)), TypeSignatureProvider.fromTypes(argumentTypes));
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, argumentTypes);
            }
            throw e;
        }
    }

    @Override
    public ResolvedFunction getCoercion(OperatorType operatorType, Type fromType, Type toType) {
        Preconditions.checkArgument((operatorType == OperatorType.CAST || operatorType == OperatorType.SATURATED_FLOOR_CAST ? 1 : 0) != 0);
        try {
            String name = Signature.mangleOperatorName(operatorType);
            return this.functionResolver.resolveCoercion(this.functions.get(QualifiedName.of((String)name)), new Signature(name, toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature())));
        }
        catch (PrestoException e) {
            if (e.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                throw new OperatorNotFoundException(operatorType, (List<? extends Type>)ImmutableList.of((Object)fromType), toType.getTypeSignature());
            }
            throw e;
        }
    }

    @Override
    public ResolvedFunction getCoercion(QualifiedName name, Type fromType, Type toType) {
        return this.functionResolver.resolveCoercion(this.functions.get(name), new Signature(name.getSuffix(), toType.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)fromType.getTypeSignature())));
    }

    @Override
    public boolean isAggregationFunction(QualifiedName name) {
        return this.functions.get(name).stream().map(FunctionMetadata::getKind).anyMatch(FunctionKind.AGGREGATE::equals);
    }

    @Override
    public FunctionMetadata getFunctionMetadata(ResolvedFunction resolvedFunction) {
        ImmutableList argumentDefinitions;
        FunctionMetadata functionMetadata = this.functions.get(resolvedFunction.getFunctionId());
        if (functionMetadata.getSignature().isVariableArity()) {
            List<FunctionArgumentDefinition> fixedArguments = functionMetadata.getArgumentDefinitions().subList(0, functionMetadata.getArgumentDefinitions().size() - 1);
            int variableArgumentCount = resolvedFunction.getSignature().getArgumentTypes().size() - fixedArguments.size();
            argumentDefinitions = ImmutableList.builder().addAll(fixedArguments).addAll(Collections.nCopies(variableArgumentCount, functionMetadata.getArgumentDefinitions().get(functionMetadata.getArgumentDefinitions().size() - 1))).build();
        } else {
            argumentDefinitions = functionMetadata.getArgumentDefinitions();
        }
        return new FunctionMetadata(functionMetadata.getFunctionId(), resolvedFunction.getSignature(), functionMetadata.isNullable(), (List<FunctionArgumentDefinition>)argumentDefinitions, functionMetadata.isHidden(), functionMetadata.isDeterministic(), functionMetadata.getDescription(), functionMetadata.getKind(), functionMetadata.isDeprecated());
    }

    @Override
    public AggregationFunctionMetadata getAggregationFunctionMetadata(ResolvedFunction resolvedFunction) {
        return this.functions.getAggregationFunctionMetadata(this, resolvedFunction);
    }

    @Override
    public WindowFunctionSupplier getWindowFunctionImplementation(ResolvedFunction resolvedFunction) {
        return this.functions.getWindowFunctionImplementation(this, resolvedFunction);
    }

    @Override
    public InternalAggregationFunction getAggregateFunctionImplementation(ResolvedFunction resolvedFunction) {
        return this.functions.getAggregateFunctionImplementation(this, resolvedFunction);
    }

    @Override
    public FunctionInvoker getScalarFunctionInvoker(ResolvedFunction resolvedFunction, Optional<InvocationConvention> invocationConvention) {
        InvocationConvention expectedConvention = invocationConvention.orElseGet(() -> this.getDefaultCallingConvention(resolvedFunction));
        return this.functions.getScalarFunctionInvoker(this, resolvedFunction, expectedConvention);
    }

    private InvocationConvention getDefaultCallingConvention(ResolvedFunction resolvedFunction) {
        FunctionMetadata functionMetadata = this.getFunctionMetadata(resolvedFunction);
        List argumentConventions = (List)functionMetadata.getSignature().getArgumentTypes().stream().map(typeSignature -> typeSignature.getBase().equalsIgnoreCase("function") ? InvocationConvention.InvocationArgumentConvention.FUNCTION : InvocationConvention.InvocationArgumentConvention.NEVER_NULL).collect(ImmutableList.toImmutableList());
        InvocationConvention.InvocationReturnConvention returnConvention = functionMetadata.isNullable() ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL;
        return new InvocationConvention(argumentConventions, returnConvention, true, false);
    }

    @Override
    public ProcedureRegistry getProcedureRegistry() {
        return this.procedures;
    }

    @Override
    public BlockEncoding getBlockEncoding(String encodingName) {
        BlockEncoding blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName);
        Preconditions.checkArgument((blockEncoding != null ? 1 : 0) != 0, (String)"Unknown block encoding: %s", (Object)encodingName);
        return blockEncoding;
    }

    @Override
    public BlockEncodingSerde getBlockEncodingSerde() {
        return new InternalBlockEncodingSerde(this);
    }

    public void addBlockEncoding(BlockEncoding blockEncoding) {
        Objects.requireNonNull(blockEncoding, "blockEncoding is null");
        BlockEncoding existingEntry = this.blockEncodings.putIfAbsent(blockEncoding.getName(), blockEncoding);
        Preconditions.checkArgument((existingEntry == null ? 1 : 0) != 0, (String)"Encoding already registered: %s", (Object)blockEncoding.getName());
    }

    @Override
    public SessionPropertyManager getSessionPropertyManager() {
        return this.sessionPropertyManager;
    }

    @Override
    public SchemaPropertyManager getSchemaPropertyManager() {
        return this.schemaPropertyManager;
    }

    @Override
    public TablePropertyManager getTablePropertyManager() {
        return this.tablePropertyManager;
    }

    @Override
    public ColumnPropertyManager getColumnPropertyManager() {
        return this.columnPropertyManager;
    }

    @Override
    public AnalyzePropertyManager getAnalyzePropertyManager() {
        return this.analyzePropertyManager;
    }

    private Optional<CatalogMetadata> getOptionalCatalogMetadata(Session session, String catalogName) {
        Optional<CatalogMetadata> optionalCatalogMetadata = this.transactionManager.getOptionalCatalogMetadata(session.getRequiredTransactionId(), catalogName);
        optionalCatalogMetadata.ifPresent(catalogMetadata -> this.registerCatalogForQuery(session, (CatalogMetadata)catalogMetadata));
        return optionalCatalogMetadata;
    }

    private CatalogMetadata getCatalogMetadata(Session session, CatalogName catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadata(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, String catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private CatalogMetadata getCatalogMetadataForWrite(Session session, CatalogName catalogName) {
        CatalogMetadata catalogMetadata = this.transactionManager.getCatalogMetadataForWrite(session.getRequiredTransactionId(), catalogName);
        this.registerCatalogForQuery(session, catalogMetadata);
        return catalogMetadata;
    }

    private ConnectorMetadata getMetadata(Session session, CatalogName catalogName) {
        return this.getCatalogMetadata(session, catalogName).getMetadataFor(catalogName);
    }

    private ConnectorMetadata getMetadataForWrite(Session session, CatalogName catalogName) {
        return this.getCatalogMetadataForWrite(session, catalogName).getMetadata();
    }

    private void registerCatalogForQuery(Session session, CatalogMetadata catalogMetadata) {
        this.catalogsByQueryId.computeIfAbsent(session.getQueryId(), queryId -> new QueryCatalogs(session)).registerCatalog(catalogMetadata);
    }

    @VisibleForTesting
    public Set<QueryId> getActiveQueryIds() {
        return ImmutableSet.copyOf(this.catalogsByQueryId.keySet());
    }

    private static class QueryCatalogs {
        private final Session session;
        @GuardedBy(value="this")
        private final Map<CatalogName, CatalogMetadata> catalogs = new HashMap<CatalogName, CatalogMetadata>();
        @GuardedBy(value="this")
        private boolean finished;

        public QueryCatalogs(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        private synchronized void registerCatalog(CatalogMetadata catalogMetadata) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Query is already finished");
            if (this.catalogs.putIfAbsent(catalogMetadata.getCatalogName(), catalogMetadata) == null) {
                ConnectorSession connectorSession = this.session.toConnectorSession(catalogMetadata.getCatalogName());
                catalogMetadata.getMetadata().beginQuery(connectorSession);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void finish() {
            ArrayList<CatalogMetadata> catalogs;
            QueryCatalogs queryCatalogs = this;
            synchronized (queryCatalogs) {
                Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Query is already finished");
                this.finished = true;
                catalogs = new ArrayList<CatalogMetadata>(this.catalogs.values());
            }
            for (CatalogMetadata catalogMetadata : catalogs) {
                ConnectorSession connectorSession = this.session.toConnectorSession(catalogMetadata.getCatalogName());
                catalogMetadata.getMetadata().cleanupQuery(connectorSession);
            }
        }
    }
}

