/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.prestosql.metadata.Metadata;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockEncoding;
import io.prestosql.spi.block.BlockEncodingSerde;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;

final class InternalBlockEncodingSerde
implements BlockEncodingSerde {
    private final Metadata metadata;

    public InternalBlockEncodingSerde(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public Block readBlock(SliceInput input) {
        String encodingName = InternalBlockEncodingSerde.readLengthPrefixedString(input);
        BlockEncoding blockEncoding = this.metadata.getBlockEncoding(encodingName);
        return blockEncoding.readBlock((BlockEncodingSerde)this, input);
    }

    public void writeBlock(SliceOutput output, Block block) {
        String encodingName;
        BlockEncoding blockEncoding;
        Optional replacementBlock;
        while ((replacementBlock = (blockEncoding = this.metadata.getBlockEncoding(encodingName = block.getEncodingName())).replacementBlockForWrite(block)).isPresent()) {
            block = (Block)replacementBlock.get();
        }
        InternalBlockEncodingSerde.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeBlock((BlockEncodingSerde)this, output, block);
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

