/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.metadata;

import com.google.common.collect.ImmutableList;
import io.prestosql.metadata.FunctionInvoker;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.ScalarFunctionAdapter;
import io.prestosql.metadata.Signature;
import io.prestosql.operator.scalar.ScalarFunctionImplementation;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.function.InvocationConvention;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class FunctionInvokerProvider {
    private final ScalarFunctionAdapter functionAdapter = new ScalarFunctionAdapter(ScalarFunctionAdapter.NullAdaptationPolicy.UNSUPPORTED);
    private final Metadata metadata;

    public FunctionInvokerProvider(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public FunctionInvoker createFunctionInvoker(ScalarFunctionImplementation scalarFunctionImplementation, Signature resolvedSignature, InvocationConvention expectedConvention) {
        ArrayList<Choice> choices = new ArrayList<Choice>();
        for (ScalarFunctionImplementation.ScalarImplementationChoice choice : scalarFunctionImplementation.getAllChoices()) {
            InvocationConvention callingConvention = FunctionInvokerProvider.toCallingConvention(choice);
            if (!this.functionAdapter.canAdapt(callingConvention, expectedConvention)) continue;
            choices.add(new Choice(choice, callingConvention));
        }
        if (choices.isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, String.format("Function implementation for (%s) cannot be adapted to convention (%s)", resolvedSignature, expectedConvention));
        }
        Choice bestChoice = Collections.max(choices, Comparator.comparingInt(Choice::getScore));
        List actualTypes = (List)resolvedSignature.getArgumentTypes().stream().map(this.metadata::getType).collect(ImmutableList.toImmutableList());
        MethodHandle methodHandle = this.functionAdapter.adapt(bestChoice.getChoice().getMethodHandle(), actualTypes, bestChoice.getCallingConvention(), expectedConvention);
        return new FunctionInvoker(methodHandle, bestChoice.getChoice().getInstanceFactory(), bestChoice.getChoice().getArgumentProperties().stream().map(ScalarFunctionImplementation.ArgumentProperty::getLambdaInterface).collect(Collectors.toList()));
    }

    private static InvocationConvention toCallingConvention(ScalarFunctionImplementation.ScalarImplementationChoice choice) {
        return new InvocationConvention((List)choice.getArgumentProperties().stream().map(FunctionInvokerProvider::toArgumentConvention).collect(ImmutableList.toImmutableList()), choice.isNullable() ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, choice.hasSession(), choice.getInstanceFactory().isPresent());
    }

    private static InvocationConvention.InvocationArgumentConvention toArgumentConvention(ScalarFunctionImplementation.ArgumentProperty argumentProperty) {
        if (argumentProperty.getArgumentType() == ScalarFunctionImplementation.ArgumentType.FUNCTION_TYPE) {
            return InvocationConvention.InvocationArgumentConvention.FUNCTION;
        }
        switch (argumentProperty.getNullConvention()) {
            case RETURN_NULL_ON_NULL: {
                return InvocationConvention.InvocationArgumentConvention.NEVER_NULL;
            }
            case USE_BOXED_TYPE: {
                return InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE;
            }
            case USE_NULL_FLAG: {
                return InvocationConvention.InvocationArgumentConvention.NULL_FLAG;
            }
            case BLOCK_AND_POSITION: {
                return InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION;
            }
        }
        throw new IllegalArgumentException("Unsupported null convention: " + argumentProperty.getNullConvention());
    }

    private static final class Choice {
        private final ScalarFunctionImplementation.ScalarImplementationChoice choice;
        private final InvocationConvention callingConvention;
        private final int score;

        public Choice(ScalarFunctionImplementation.ScalarImplementationChoice choice, InvocationConvention callingConvention) {
            this.choice = Objects.requireNonNull(choice, "choice is null");
            this.callingConvention = Objects.requireNonNull(callingConvention, "callingConvention is null");
            int score = 0;
            for (InvocationConvention.InvocationArgumentConvention argument : callingConvention.getArgumentConventions()) {
                if (argument == InvocationConvention.InvocationArgumentConvention.NULL_FLAG) {
                    ++score;
                    continue;
                }
                if (argument != InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION) continue;
                score += 1000;
            }
            this.score = score;
        }

        public ScalarFunctionImplementation.ScalarImplementationChoice getChoice() {
            return this.choice;
        }

        public InvocationConvention getCallingConvention() {
            return this.callingConvention;
        }

        public int getScore() {
            return this.score;
        }
    }
}

