/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.client.ClientCapabilities;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.sql.SqlPath;
import io.prestosql.sql.SqlPathElement;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.SetPath;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class SetPathTask
implements DataDefinitionTask<SetPath> {
    @Override
    public String getName() {
        return "SET PATH";
    }

    @Override
    public ListenableFuture<?> execute(SetPath statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        if (!session.getClientCapabilities().contains(ClientCapabilities.PATH.toString())) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "SET PATH not supported by client");
        }
        SqlPath sqlPath = new SqlPath(Optional.of(statement.getPathSpecification().toString()));
        for (SqlPathElement element : sqlPath.getParsedPath()) {
            if (element.getCatalog().isEmpty() && session.getCatalog().isEmpty()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, (Node)statement, "Catalog must be specified for each path element when session catalog is not set", new Object[0]);
            }
            element.getCatalog().ifPresent(catalog -> {
                String catalogName = catalog.getValue().toLowerCase(Locale.ENGLISH);
                if (metadata.getCatalogHandle(session, catalogName).isEmpty()) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + catalogName);
                }
            });
        }
        stateMachine.setSetPath(sqlPath.toString());
        return Futures.immediateFuture(null);
    }
}

