/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.execution.DataDefinitionTask;
import io.prestosql.execution.QueryStateMachine;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.security.AccessControl;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ConnectorViewDefinition;
import io.prestosql.sql.analyzer.SemanticExceptions;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.RenameView;
import io.prestosql.transaction.TransactionManager;
import java.util.List;
import java.util.Optional;

public class RenameViewTask
implements DataDefinitionTask<RenameView> {
    @Override
    public String getName() {
        return "RENAME VIEW";
    }

    @Override
    public ListenableFuture<?> execute(RenameView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        QualifiedObjectName viewName;
        Session session = stateMachine.getSession();
        Optional<ConnectorViewDefinition> viewDefinition = metadata.getView(session, viewName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource()));
        if (viewDefinition.isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "View '%s' does not exist", viewName);
        }
        QualifiedObjectName target = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTarget());
        if (metadata.getCatalogHandle(session, target.getCatalogName()).isEmpty()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, (Node)statement, "Target catalog '%s' does not exist", target.getCatalogName());
        }
        if (metadata.getView(session, target).isPresent()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target view '%s' already exists", target);
        }
        if (!viewName.getCatalogName().equals(target.getCatalogName())) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "View rename across catalogs is not supported", new Object[0]);
        }
        accessControl.checkCanRenameView(session.toSecurityContext(), viewName, target);
        metadata.renameView(session, viewName, target);
        return Futures.immediateFuture(null);
    }
}

