/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.dispatcher;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.prestosql.Session;
import io.prestosql.dispatcher.DispatchExecutor;
import io.prestosql.dispatcher.DispatchInfo;
import io.prestosql.dispatcher.DispatchQuery;
import io.prestosql.dispatcher.DispatchQueryFactory;
import io.prestosql.dispatcher.FailedDispatchQuery;
import io.prestosql.dispatcher.FailedDispatchQueryFactory;
import io.prestosql.execution.ManagedQueryExecution;
import io.prestosql.execution.QueryIdGenerator;
import io.prestosql.execution.QueryInfo;
import io.prestosql.execution.QueryManagerConfig;
import io.prestosql.execution.QueryManagerStats;
import io.prestosql.execution.QueryPreparer;
import io.prestosql.execution.QueryState;
import io.prestosql.execution.QueryTracker;
import io.prestosql.execution.resourcegroups.ResourceGroupManager;
import io.prestosql.metadata.SessionPropertyManager;
import io.prestosql.security.AccessControl;
import io.prestosql.server.BasicQueryInfo;
import io.prestosql.server.SessionContext;
import io.prestosql.server.SessionPropertyDefaults;
import io.prestosql.server.SessionSupplier;
import io.prestosql.server.protocol.Slug;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.QueryId;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.resourcegroups.SelectionContext;
import io.prestosql.spi.resourcegroups.SelectionCriteria;
import io.prestosql.transaction.TransactionManager;
import io.prestosql.util.StatementUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

public class DispatchManager {
    private final QueryIdGenerator queryIdGenerator;
    private final QueryPreparer queryPreparer;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final DispatchQueryFactory dispatchQueryFactory;
    private final FailedDispatchQueryFactory failedDispatchQueryFactory;
    private final TransactionManager transactionManager;
    private final AccessControl accessControl;
    private final SessionSupplier sessionSupplier;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final int maxQueryLength;
    private final Executor queryExecutor;
    private final QueryTracker<DispatchQuery> queryTracker;
    private final QueryManagerStats stats = new QueryManagerStats();

    @Inject
    public DispatchManager(QueryIdGenerator queryIdGenerator, QueryPreparer queryPreparer, ResourceGroupManager<?> resourceGroupManager, DispatchQueryFactory dispatchQueryFactory, FailedDispatchQueryFactory failedDispatchQueryFactory, TransactionManager transactionManager, AccessControl accessControl, SessionSupplier sessionSupplier, SessionPropertyDefaults sessionPropertyDefaults, QueryManagerConfig queryManagerConfig, DispatchExecutor dispatchExecutor) {
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.queryPreparer = Objects.requireNonNull(queryPreparer, "queryPreparer is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.dispatchQueryFactory = Objects.requireNonNull(dispatchQueryFactory, "dispatchQueryFactory is null");
        this.failedDispatchQueryFactory = Objects.requireNonNull(failedDispatchQueryFactory, "failedDispatchQueryFactory is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionSupplier = Objects.requireNonNull(sessionSupplier, "sessionSupplier is null");
        this.sessionPropertyDefaults = Objects.requireNonNull(sessionPropertyDefaults, "sessionPropertyDefaults is null");
        Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.maxQueryLength = queryManagerConfig.getMaxQueryLength();
        this.queryExecutor = Objects.requireNonNull(dispatchExecutor, "dispatchExecutor is null").getExecutor();
        this.queryTracker = new QueryTracker(queryManagerConfig, (ScheduledExecutorService)dispatchExecutor.getScheduledExecutor());
    }

    @PostConstruct
    public void start() {
        this.queryTracker.start();
    }

    @PreDestroy
    public void stop() {
        this.queryTracker.stop();
    }

    @Managed
    @Flatten
    public QueryManagerStats getStats() {
        return this.stats;
    }

    public QueryId createQueryId() {
        return this.queryIdGenerator.createNextQueryId();
    }

    public ListenableFuture<?> createQuery(QueryId queryId, Slug slug, SessionContext sessionContext, String query) {
        Objects.requireNonNull(queryId, "queryId is null");
        Objects.requireNonNull(sessionContext, "sessionFactory is null");
        Objects.requireNonNull(query, "query is null");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query must not be empty string");
        Preconditions.checkArgument((boolean)this.queryTracker.tryGetQuery(queryId).isEmpty(), (String)"query %s already exists", (Object)queryId);
        DispatchQueryCreationFuture queryCreationFuture = new DispatchQueryCreationFuture();
        this.queryExecutor.execute(() -> {
            try {
                this.createQueryInternal(queryId, slug, sessionContext, query, this.resourceGroupManager);
            }
            finally {
                queryCreationFuture.set(null);
            }
        });
        return queryCreationFuture;
    }

    private <C> void createQueryInternal(QueryId queryId, Slug slug, SessionContext sessionContext, String query, ResourceGroupManager<C> resourceGroupManager) {
        Session session = null;
        QueryPreparer.PreparedQuery preparedQuery = null;
        try {
            if (query.length() > this.maxQueryLength) {
                int queryLength = query.length();
                query = query.substring(0, this.maxQueryLength);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_TEXT_TOO_LARGE, String.format("Query text length (%s) exceeds the maximum length (%s)", queryLength, this.maxQueryLength));
            }
            session = this.sessionSupplier.createSession(queryId, sessionContext);
            this.accessControl.checkCanExecuteQuery(sessionContext.getIdentity());
            preparedQuery = this.queryPreparer.prepareQuery(session, query);
            Optional<String> queryType = StatementUtils.getQueryType(preparedQuery.getStatement().getClass()).map(Enum::name);
            SelectionContext<C> selectionContext = resourceGroupManager.selectGroup(new SelectionCriteria(sessionContext.getIdentity().getPrincipal().isPresent(), sessionContext.getIdentity().getUser(), sessionContext.getIdentity().getGroups(), Optional.ofNullable(sessionContext.getSource()), sessionContext.getClientTags(), sessionContext.getResourceEstimates(), queryType));
            session = this.sessionPropertyDefaults.newSessionWithDefaultProperties(session, queryType, selectionContext.getResourceGroupId());
            this.transactionManager.activateTransaction(session, StatementUtils.isTransactionControlStatement(preparedQuery.getStatement()), this.accessControl);
            DispatchQuery dispatchQuery = this.dispatchQueryFactory.createDispatchQuery(session, query, preparedQuery, slug, selectionContext.getResourceGroupId());
            boolean queryAdded = this.queryCreated(dispatchQuery);
            if (queryAdded && !dispatchQuery.isDone()) {
                try {
                    resourceGroupManager.submit(dispatchQuery, selectionContext, this.queryExecutor);
                }
                catch (Throwable e) {
                    dispatchQuery.fail(e);
                }
            }
        }
        catch (Throwable throwable) {
            if (session == null) {
                session = Session.builder(new SessionPropertyManager()).setQueryId(queryId).setIdentity(sessionContext.getIdentity()).setSource(sessionContext.getSource()).build();
            }
            Optional<String> preparedSql = Optional.ofNullable(preparedQuery).flatMap(QueryPreparer.PreparedQuery::getPrepareSql);
            FailedDispatchQuery failedDispatchQuery = this.failedDispatchQueryFactory.createFailedDispatchQuery(session, query, preparedSql, Optional.empty(), throwable);
            this.queryCreated(failedDispatchQuery);
        }
    }

    private boolean queryCreated(DispatchQuery dispatchQuery) {
        boolean queryAdded = this.queryTracker.addQuery(dispatchQuery);
        if (queryAdded) {
            dispatchQuery.addStateChangeListener(newState -> {
                if (newState.isDone()) {
                    this.queryTracker.expireQuery(dispatchQuery.getQueryId());
                }
            });
            this.stats.trackQueryStats(dispatchQuery);
        }
        return queryAdded;
    }

    public ListenableFuture<?> waitForDispatched(QueryId queryId) {
        return this.queryTracker.tryGetQuery(queryId).map(dispatchQuery -> {
            dispatchQuery.recordHeartbeat();
            return dispatchQuery.getDispatchedFuture();
        }).orElseGet(() -> Futures.immediateFuture(null));
    }

    public List<BasicQueryInfo> getQueries() {
        return (List)this.queryTracker.getAllQueries().stream().map(ManagedQueryExecution::getBasicQueryInfo).collect(ImmutableList.toImmutableList());
    }

    @Managed
    public long getQueuedQueries() {
        return this.queryTracker.getAllQueries().stream().filter(query -> query.getBasicQueryInfo().getState() == QueryState.QUEUED).count();
    }

    @Managed
    public long getRunningQueries() {
        return this.queryTracker.getAllQueries().stream().filter(query -> query.getBasicQueryInfo().getState() == QueryState.RUNNING && !query.getBasicQueryInfo().getQueryStats().isFullyBlocked()).count();
    }

    public boolean isQueryRegistered(QueryId queryId) {
        return this.queryTracker.tryGetQuery(queryId).isPresent();
    }

    public DispatchQuery getQuery(QueryId queryId) {
        return this.queryTracker.getQuery(queryId);
    }

    public BasicQueryInfo getQueryInfo(QueryId queryId) {
        return this.queryTracker.getQuery(queryId).getBasicQueryInfo();
    }

    public Optional<QueryInfo> getFullQueryInfo(QueryId queryId) {
        return this.queryTracker.tryGetQuery(queryId).map(ManagedQueryExecution::getFullQueryInfo);
    }

    public Optional<DispatchInfo> getDispatchInfo(QueryId queryId) {
        return this.queryTracker.tryGetQuery(queryId).map(dispatchQuery -> {
            dispatchQuery.recordHeartbeat();
            return dispatchQuery.getDispatchInfo();
        });
    }

    public void cancelQuery(QueryId queryId) {
        this.queryTracker.tryGetQuery(queryId).ifPresent(DispatchQuery::cancel);
    }

    public void failQuery(QueryId queryId, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.queryTracker.tryGetQuery(queryId).ifPresent(query -> query.fail(cause));
    }

    private static class DispatchQueryCreationFuture
    extends AbstractFuture<QueryInfo> {
        private DispatchQueryCreationFuture() {
        }

        protected boolean set(QueryInfo value) {
            return super.set((Object)value);
        }

        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }
    }
}

