/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.system;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import io.prestosql.connector.system.SystemTablesProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SystemTable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DelegatingSystemTablesProvider
implements SystemTablesProvider {
    private final List<SystemTablesProvider> delegates;

    public DelegatingSystemTablesProvider(SystemTablesProvider ... delegates) {
        this((List<SystemTablesProvider>)ImmutableList.copyOf((Object[])delegates));
    }

    public DelegatingSystemTablesProvider(List<SystemTablesProvider> delegates) {
        Objects.requireNonNull(delegates, "delegates is null");
        Preconditions.checkArgument((delegates.size() >= 1 ? 1 : 0) != 0, (Object)"empty delegates");
        this.delegates = ImmutableList.copyOf(delegates);
    }

    @Override
    public Set<SystemTable> listSystemTables(ConnectorSession session) {
        return (Set)this.delegates.stream().flatMap(delegate -> delegate.listSystemTables(session).stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return (Optional)this.delegates.stream().map(delegate -> delegate.getSystemTable(session, tableName)).filter(Optional::isPresent).map(Optional::get).collect(MoreCollectors.toOptional());
    }
}

