/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.connector.informationschema;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.prestosql.FullConnectorSession;
import io.prestosql.Session;
import io.prestosql.connector.informationschema.InformationSchemaColumnHandle;
import io.prestosql.connector.informationschema.InformationSchemaTable;
import io.prestosql.connector.informationschema.InformationSchemaTableHandle;
import io.prestosql.metadata.Metadata;
import io.prestosql.metadata.MetadataUtil;
import io.prestosql.metadata.QualifiedObjectName;
import io.prestosql.metadata.QualifiedTablePrefix;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.ConstraintApplicationResult;
import io.prestosql.spi.connector.LimitApplicationResult;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.predicate.Domain;
import io.prestosql.spi.predicate.EquatableValueSet;
import io.prestosql.spi.predicate.NullableValue;
import io.prestosql.spi.predicate.Range;
import io.prestosql.spi.predicate.SortedRangeSet;
import io.prestosql.spi.predicate.TupleDomain;
import io.prestosql.spi.type.Type;
import io.prestosql.spi.type.VarcharType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InformationSchemaMetadata
implements ConnectorMetadata {
    private static final InformationSchemaColumnHandle CATALOG_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_catalog");
    private static final InformationSchemaColumnHandle SCHEMA_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_schema");
    private static final InformationSchemaColumnHandle TABLE_NAME_COLUMN_HANDLE = new InformationSchemaColumnHandle("table_name");
    private static final InformationSchemaColumnHandle ROLE_NAME_COLUMN_HANDLE = new InformationSchemaColumnHandle("role_name");
    private static final InformationSchemaColumnHandle GRANTEE_COLUMN_HANDLE = new InformationSchemaColumnHandle("grantee");
    private static final int MAX_PREFIXES_COUNT = 100;
    private static final int MAX_ROLE_COUNT = 100;
    private final String catalogName;
    private final Metadata metadata;

    public InformationSchemaMetadata(String catalogName, Metadata metadata) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)"information_schema");
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession connectorSession, SchemaTableName tableName) {
        return InformationSchemaTable.of(tableName).map(table -> new InformationSchemaTableHandle(this.catalogName, (InformationSchemaTable)((Object)table), InformationSchemaMetadata.defaultPrefixes(this.catalogName), Optional.empty(), Optional.empty(), OptionalLong.empty())).orElse(null);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)tableHandle;
        return informationSchemaTableHandle.getTable().getTableMetadata();
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && !schemaName.get().equals("information_schema")) {
            return ImmutableList.of();
        }
        return (List)Arrays.stream(InformationSchemaTable.values()).map(InformationSchemaTable::getSchemaTableName).collect(ImmutableList.toImmutableList());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        String columnName;
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)tableHandle;
        ConnectorTableMetadata tableMetadata = informationSchemaTableHandle.getTable().getTableMetadata();
        ColumnMetadata columnMetadata = MetadataUtil.findColumnMetadata(tableMetadata, columnName = ((InformationSchemaColumnHandle)columnHandle).getColumnName());
        Preconditions.checkArgument((columnMetadata != null ? 1 : 0) != 0, (String)"Column '%s' on table '%s' does not exist", (Object)columnName, (Object)tableMetadata.getTable());
        return columnMetadata;
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        InformationSchemaTableHandle informationSchemaTableHandle = (InformationSchemaTableHandle)tableHandle;
        ConnectorTableMetadata tableMetadata = informationSchemaTableHandle.getTable().getTableMetadata();
        return tableMetadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toMap(Function.identity(), InformationSchemaColumnHandle::new));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        return (Map)Arrays.stream(InformationSchemaTable.values()).filter(table -> prefix.matches(table.getSchemaTableName())).collect(ImmutableMap.toImmutableMap(InformationSchemaTable::getSchemaTableName, table -> table.getTableMetadata().getColumns()));
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        InformationSchemaTableHandle tableHandle = (InformationSchemaTableHandle)table;
        return new ConnectorTableProperties(tableHandle.getPrefixes().isEmpty() ? TupleDomain.none() : TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle handle, long limit) {
        InformationSchemaTableHandle table = (InformationSchemaTableHandle)handle;
        if (table.getLimit().isPresent() && table.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        return Optional.of(new LimitApplicationResult((Object)new InformationSchemaTableHandle(table.getCatalogName(), table.getTable(), table.getPrefixes(), table.getRoles(), table.getGrantees(), OptionalLong.of(limit)), true));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        InformationSchemaTableHandle table = (InformationSchemaTableHandle)handle;
        Optional<Set<String>> roles = table.getRoles();
        Optional<Set<String>> grantees = table.getGrantees();
        if (InformationSchemaTable.ROLE_AUTHORIZATION_DESCRIPTORS.equals((Object)table.getTable()) && table.getRoles().isEmpty() && table.getGrantees().isEmpty()) {
            roles = this.calculateRoles(session, (TupleDomain<ColumnHandle>)constraint.getSummary(), constraint.predicate());
            grantees = this.calculateGrantees(session, (TupleDomain<ColumnHandle>)constraint.getSummary(), constraint.predicate());
        }
        Set<QualifiedTablePrefix> prefixes = table.getPrefixes();
        if (InformationSchemaMetadata.isTablesEnumeratingTable(table.getTable()) && table.getPrefixes().equals(InformationSchemaMetadata.defaultPrefixes(this.catalogName))) {
            prefixes = this.getPrefixes(session, table, constraint);
        }
        if (roles.equals(table.getRoles()) && grantees.equals(table.getGrantees()) && prefixes.equals(table.getPrefixes())) {
            return Optional.empty();
        }
        table = new InformationSchemaTableHandle(table.getCatalogName(), table.getTable(), prefixes, roles, grantees, table.getLimit());
        return Optional.of(new ConstraintApplicationResult((Object)table, constraint.getSummary()));
    }

    public static Set<QualifiedTablePrefix> defaultPrefixes(String catalogName) {
        return ImmutableSet.of((Object)new QualifiedTablePrefix(catalogName));
    }

    private Set<QualifiedTablePrefix> getPrefixes(ConnectorSession session, InformationSchemaTableHandle table, Constraint constraint) {
        Set<QualifiedTablePrefix> prefixes;
        if (constraint.getSummary().isNone()) {
            return ImmutableSet.of();
        }
        Optional<Set<String>> catalogs = this.filterString(constraint.getSummary(), CATALOG_COLUMN_HANDLE);
        if (catalogs.isPresent() && !catalogs.get().contains(table.getCatalogName())) {
            return ImmutableSet.of();
        }
        InformationSchemaTable informationSchemaTable = table.getTable();
        Set<QualifiedTablePrefix> tablePrefixes = this.calculatePrefixesWithTableName(informationSchemaTable, session, prefixes = this.calculatePrefixesWithSchemaName(session, (TupleDomain<ColumnHandle>)constraint.getSummary(), constraint.predicate()), (TupleDomain<ColumnHandle>)constraint.getSummary(), constraint.predicate());
        if (tablePrefixes.size() <= 100) {
            prefixes = tablePrefixes;
        }
        if (prefixes.size() > 100) {
            prefixes = InformationSchemaMetadata.defaultPrefixes(this.catalogName);
        }
        return prefixes;
    }

    public static boolean isTablesEnumeratingTable(InformationSchemaTable table) {
        return ImmutableSet.of((Object)((Object)InformationSchemaTable.COLUMNS), (Object)((Object)InformationSchemaTable.VIEWS), (Object)((Object)InformationSchemaTable.TABLES), (Object)((Object)InformationSchemaTable.TABLE_PRIVILEGES)).contains((Object)table);
    }

    private Optional<Set<String>> calculateRoles(ConnectorSession connectorSession, TupleDomain<ColumnHandle> constraint, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        if (constraint.isNone()) {
            return Optional.empty();
        }
        Optional<Set<String>> roles = this.filterString(constraint, ROLE_NAME_COLUMN_HANDLE);
        if (roles.isPresent()) {
            Set result = (Set)roles.get().stream().filter(this::isLowerCase).filter(role -> !predicate.isPresent() || ((Predicate)predicate.get()).test(this.roleAsFixedValues((String)role))).collect(ImmutableSet.toImmutableSet());
            if (result.isEmpty()) {
                return Optional.empty();
            }
            if (result.size() <= 100) {
                return Optional.of(result);
            }
        }
        if (predicate.isEmpty()) {
            return Optional.empty();
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        return Optional.of((Set)this.metadata.listRoles(session, this.catalogName).stream().filter(role -> ((Predicate)predicate.get()).test(this.roleAsFixedValues((String)role))).collect(ImmutableSet.toImmutableSet()));
    }

    private Optional<Set<String>> calculateGrantees(ConnectorSession connectorSession, TupleDomain<ColumnHandle> constraint, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        if (constraint.isNone()) {
            return Optional.empty();
        }
        Optional<Set<String>> grantees = this.filterString(constraint, GRANTEE_COLUMN_HANDLE);
        if (grantees.isEmpty()) {
            return Optional.empty();
        }
        Set result = (Set)grantees.get().stream().filter(this::isLowerCase).filter(role -> !predicate.isPresent() || ((Predicate)predicate.get()).test(this.granteeAsFixedValues((String)role))).collect(ImmutableSet.toImmutableSet());
        if (!result.isEmpty() && result.size() <= 100) {
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Set<QualifiedTablePrefix> calculatePrefixesWithSchemaName(ConnectorSession connectorSession, TupleDomain<ColumnHandle> constraint, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        Optional<Set<String>> schemas = this.filterString(constraint, SCHEMA_COLUMN_HANDLE);
        if (schemas.isPresent()) {
            return (Set)schemas.get().stream().filter(this::isLowerCase).filter(schema -> predicate.isEmpty() || ((Predicate)predicate.get()).test(this.schemaAsFixedValues((String)schema))).map(schema -> new QualifiedTablePrefix(this.catalogName, (String)schema)).collect(ImmutableSet.toImmutableSet());
        }
        if (predicate.isEmpty()) {
            return ImmutableSet.of((Object)new QualifiedTablePrefix(this.catalogName));
        }
        Session session = ((FullConnectorSession)connectorSession).getSession();
        return (Set)this.listSchemaNames(session).filter(prefix -> ((Predicate)predicate.get()).test(this.schemaAsFixedValues(prefix.getSchemaName().get()))).collect(ImmutableSet.toImmutableSet());
    }

    private Set<QualifiedTablePrefix> calculatePrefixesWithTableName(InformationSchemaTable informationSchemaTable, ConnectorSession connectorSession, Set<QualifiedTablePrefix> prefixes, TupleDomain<ColumnHandle> constraint, Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate) {
        Session session = ((FullConnectorSession)connectorSession).getSession();
        Optional<Set<String>> tables = this.filterString(constraint, TABLE_NAME_COLUMN_HANDLE);
        if (tables.isPresent()) {
            return (Set)prefixes.stream().peek(prefix -> Verify.verify((boolean)prefix.asQualifiedObjectName().isEmpty())).flatMap(prefix -> prefix.getSchemaName().map(schemaName -> Stream.of(prefix)).orElseGet(() -> this.listSchemaNames(session))).flatMap(prefix -> ((Set)tables.get()).stream().filter(this::isLowerCase).map(table -> new QualifiedObjectName(this.catalogName, prefix.getSchemaName().get(), (String)table))).filter(objectName -> !this.isColumnsEnumeratingTable(informationSchemaTable) || this.metadata.getTableHandle(session, (QualifiedObjectName)objectName).isPresent() || this.metadata.getView(session, (QualifiedObjectName)objectName).isPresent()).filter(objectName -> predicate.isEmpty() || ((Predicate)predicate.get()).test(this.asFixedValues((QualifiedObjectName)objectName))).map(QualifiedObjectName::asQualifiedTablePrefix).collect(ImmutableSet.toImmutableSet());
        }
        if (predicate.isEmpty() || !this.isColumnsEnumeratingTable(informationSchemaTable)) {
            return prefixes;
        }
        return (Set)prefixes.stream().flatMap(prefix -> Stream.concat(this.metadata.listTables(session, (QualifiedTablePrefix)prefix).stream(), this.metadata.listViews(session, (QualifiedTablePrefix)prefix).stream())).filter(objectName -> ((Predicate)predicate.get()).test(this.asFixedValues((QualifiedObjectName)objectName))).map(QualifiedObjectName::asQualifiedTablePrefix).collect(ImmutableSet.toImmutableSet());
    }

    private boolean isColumnsEnumeratingTable(InformationSchemaTable table) {
        return InformationSchemaTable.COLUMNS == table;
    }

    private Stream<QualifiedTablePrefix> listSchemaNames(Session session) {
        return this.metadata.listSchemaNames(session, this.catalogName).stream().map(schema -> new QualifiedTablePrefix(this.catalogName, (String)schema));
    }

    private <T> Optional<Set<String>> filterString(TupleDomain<T> constraint, T column) {
        if (constraint.isNone()) {
            return Optional.of(ImmutableSet.of());
        }
        Domain domain = (Domain)((Map)constraint.getDomains().get()).get(column);
        if (domain == null) {
            return Optional.empty();
        }
        if (domain.isSingleValue()) {
            return Optional.of(ImmutableSet.of((Object)((Slice)domain.getSingleValue()).toStringUtf8()));
        }
        if (domain.getValues() instanceof EquatableValueSet) {
            Collection values = ((EquatableValueSet)domain.getValues()).getValues();
            return Optional.of((Set)values.stream().map(Slice.class::cast).map(Slice::toStringUtf8).collect(ImmutableSet.toImmutableSet()));
        }
        if (domain.getValues() instanceof SortedRangeSet) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (Range range : domain.getValues().getRanges().getOrderedRanges()) {
                Preconditions.checkState((!range.isAll() ? 1 : 0) != 0);
                if (!range.isSingleValue()) {
                    return Optional.empty();
                }
                result.add((Object)((Slice)range.getSingleValue()).toStringUtf8());
            }
            return Optional.of(result.build());
        }
        return Optional.empty();
    }

    private Map<ColumnHandle, NullableValue> schemaAsFixedValues(String schema) {
        return ImmutableMap.of((Object)SCHEMA_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)schema)));
    }

    private Map<ColumnHandle, NullableValue> roleAsFixedValues(String schema) {
        return ImmutableMap.of((Object)ROLE_NAME_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)schema)));
    }

    private Map<ColumnHandle, NullableValue> granteeAsFixedValues(String schema) {
        return ImmutableMap.of((Object)GRANTEE_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)schema)));
    }

    private Map<ColumnHandle, NullableValue> asFixedValues(QualifiedObjectName objectName) {
        return ImmutableMap.of((Object)CATALOG_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.getCatalogName())), (Object)SCHEMA_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.getSchemaName())), (Object)TABLE_NAME_COLUMN_HANDLE, (Object)new NullableValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)objectName.getObjectName())));
    }

    private boolean isLowerCase(String value) {
        return value.toLowerCase(Locale.ENGLISH).equals(value);
    }
}

