/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql;

import io.prestosql.GroupByHashPageIndexer;
import io.prestosql.spi.Page;
import io.prestosql.spi.PageIndexer;
import io.prestosql.spi.PageIndexerFactory;
import io.prestosql.spi.type.Type;
import io.prestosql.sql.gen.JoinCompiler;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class GroupByHashPageIndexerFactory
implements PageIndexerFactory {
    private final JoinCompiler joinCompiler;

    @Inject
    public GroupByHashPageIndexerFactory(JoinCompiler joinCompiler) {
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
    }

    public PageIndexer createPageIndexer(List<? extends Type> types) {
        if (types.isEmpty()) {
            return new NoHashPageIndexer();
        }
        return new GroupByHashPageIndexer(types, this.joinCompiler);
    }

    private static class NoHashPageIndexer
    implements PageIndexer {
        private NoHashPageIndexer() {
        }

        public int[] indexPage(Page page) {
            return new int[page.getPositionCount()];
        }

        public int getMaxIndex() {
            return 0;
        }
    }
}

