/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.eureka;

import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClientConfig;
import io.pivotal.spring.cloud.service.eureka.ClientFilterAdapter;
import io.pivotal.spring.cloud.service.eureka.EurekaOAuth2RequestDecorator;
import io.pivotal.spring.cloud.service.eureka.EurekaOAuth2ResourceDetails;
import java.util.ArrayList;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.netflix.eureka.EurekaClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaClientConfig.class, OAuth2RestTemplate.class})
@ConditionalOnProperty(value={"eureka.client.oauth2.clientId"})
@AutoConfigureBefore(value={EurekaClientAutoConfiguration.class})
public class EurekaOAuth2AutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={EurekaOAuth2RequestDecorator.class})
    public EurekaOAuth2RequestDecorator eurekaOauth2RequestDecorator() {
        return new EurekaOAuth2RequestDecorator(this.eurekaOAuth2ResourceDetails());
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaOAuth2ResourceDetails.class})
    public EurekaOAuth2ResourceDetails eurekaOAuth2ResourceDetails() {
        return new EurekaOAuth2ResourceDetails();
    }

    @Bean
    @ConditionalOnMissingBean(value={DiscoveryClient.DiscoveryClientOptionalArgs.class})
    public DiscoveryClient.DiscoveryClientOptionalArgs discoveryClientOptionalArgs() {
        ArrayList<ClientFilterAdapter> filters = new ArrayList<ClientFilterAdapter>();
        filters.add(new ClientFilterAdapter(this.eurekaOauth2RequestDecorator()));
        DiscoveryClient.DiscoveryClientOptionalArgs args = new DiscoveryClient.DiscoveryClientOptionalArgs();
        args.setAdditionalFilters(filters);
        return args;
    }
}

