/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.config;

import io.pivotal.spring.cloud.service.config.ConfigClientOAuth2BootstrapConfiguration;
import io.pivotal.spring.cloud.service.config.ConfigClientOAuth2ResourceDetails;
import io.pivotal.spring.cloud.service.config.PlainTextConfigClient;
import io.pivotal.spring.cloud.service.config.PlainTextOAuth2ConfigClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.client.ConfigClientAutoConfiguration;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;

@Configuration
@ConditionalOnClass(value={OAuth2ProtectedResourceDetails.class, ConfigClientProperties.class})
@AutoConfigureAfter(value={ConfigClientAutoConfiguration.class, ConfigClientOAuth2BootstrapConfiguration.class})
public class PlainTextConfigClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PlainTextConfigClient.class})
    @ConditionalOnProperty(prefix="spring.cloud.config.client.oauth2", name={"client-id", "client-secret"})
    public PlainTextConfigClient plainTextConfigClient(ConfigClientOAuth2ResourceDetails resource, ConfigClientProperties configClientProperties) {
        return new PlainTextOAuth2ConfigClient((OAuth2ProtectedResourceDetails)resource, configClientProperties);
    }
}

