/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.cfenv.test;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.pivotal.cfenv.core.CfEnvSingleton;
import io.pivotal.cfenv.core.UriInfo;
import io.pivotal.cfenv.test.CfEnvTestUtils;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import mockit.MockUp;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.mockito.MockitoAnnotations;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;

public abstract class AbstractCfEnvTests {
    protected static final String hostname = "10.20.30.40";
    protected static final int port = 1234;
    protected static final String password = "mypass";
    protected static final String username = "myuser";
    private static ObjectMapper objectMapper = new ObjectMapper();

    private static String getServiceLabel(String servicePayload) {
        try {
            Map serviceMap = (Map)objectMapper.readValue(servicePayload, Map.class);
            return serviceMap.get("label").toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected static String getServicesPayload(String ... servicePayloads) {
        HashMap<String, ArrayList<String>> labelPayloadMap = new HashMap<String, ArrayList<String>>();
        for (String payload : servicePayloads) {
            String label = AbstractCfEnvTests.getServiceLabel(payload);
            ArrayList<String> payloadsForLabel = (ArrayList<String>)labelPayloadMap.get(label);
            if (payloadsForLabel == null) {
                payloadsForLabel = new ArrayList<String>();
                labelPayloadMap.put(label, payloadsForLabel);
            }
            payloadsForLabel.add(payload);
        }
        StringBuilder result = new StringBuilder("{\n");
        int labelSize = labelPayloadMap.size();
        int i = 0;
        for (Map.Entry entry : labelPayloadMap.entrySet()) {
            result.append(AbstractCfEnvTests.quote((String)entry.getKey())).append(":");
            result.append(AbstractCfEnvTests.getServicePayload((List)entry.getValue()));
            if (i++ == labelSize - 1) continue;
            result.append(",\n");
        }
        result.append("}");
        return result.toString();
    }

    private static String getServicePayload(List<String> servicePayloads) {
        StringBuilder payload = new StringBuilder("[");
        for (int i = 0; i < servicePayloads.size(); ++i) {
            payload.append(servicePayloads.get(i));
            if (i == servicePayloads.size() - 1) continue;
            payload.append(",");
        }
        payload.append("]");
        return payload.toString();
    }

    private static String quote(String str) {
        return "\"" + str + "\"";
    }

    protected MockUp<?> mockVcapServices(String serviceJson) {
        return CfEnvTestUtils.mockVcapServicesFromString(serviceJson);
    }

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @After
    public void after() throws Exception {
        Field field = CfEnvSingleton.class.getDeclaredField("INSTANCE");
        field.setAccessible(true);
        field.set(null, null);
    }

    protected String getTemplatedPayload(String templateFile, String serviceName, String hostname, int port, String user, String password, String name) {
        String payload = this.readTestDataFile(templateFile);
        payload = payload.replace("$serviceName", serviceName);
        payload = payload.replace("$hostname", hostname);
        payload = payload.replace("$port", Integer.toString(port));
        payload = payload.replace("$user", UriInfo.urlEncode((String)user));
        payload = payload.replace("$password", UriInfo.urlEncode((String)password));
        payload = payload.replace("$name", name);
        return payload;
    }

    public Environment getEnvironment() {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{TestApp.class}).web(WebApplicationType.NONE);
        builder.bannerMode(Banner.Mode.OFF);
        ConfigurableApplicationContext applicationContext = builder.run(new String[0]);
        return applicationContext.getEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readTestDataFile(String fileName) {
        try (Scanner scanner = null;){
            InputStreamReader fileReader = new InputStreamReader(this.getClass().getResourceAsStream(fileName));
            scanner = new Scanner(fileReader);
            String string = scanner.useDelimiter("\\Z").next();
            return string;
        }
    }

    protected String getUserProvidedServicePayload(String serviceName, String hostname, int port, String user, String password, String name, String scheme) {
        String payload = this.getTemplatedPayload("/test-ups-info.json", serviceName, hostname, port, user, password, name);
        return payload.replace("$scheme", scheme);
    }

    protected String getUserProvidedServicePayloadWithNoUri(String serviceName, String hostname, int port, String user, String password, String name) {
        return this.getTemplatedPayload("/test-ups-info-no-uri.json", serviceName, hostname, port, user, password, name);
    }

    protected void assertUriInfo(UriInfo uriInfo, String scheme, String instanceName) {
        Assertions.assertThat((String)uriInfo.getScheme()).isEqualTo(scheme);
        Assertions.assertThat((String)uriInfo.getPath()).isEqualTo(instanceName);
        this.assertCommonUriFields(uriInfo);
    }

    protected void assertUriInfo(UriInfo uriInfo, String scheme, String instanceName, String uname, String pwd) {
        Assertions.assertThat((String)uriInfo.getScheme()).isEqualTo(scheme);
        Assertions.assertThat((String)uriInfo.getPath()).isEqualTo(instanceName);
        this.assertHostPort(uriInfo);
        Assertions.assertThat((String)uriInfo.getUsername()).isEqualTo(uname);
        Assertions.assertThat((String)uriInfo.getPassword()).isEqualTo(pwd);
    }

    private void assertCommonUriFields(UriInfo uriInfo) {
        this.assertHostPort(uriInfo);
        Assertions.assertThat((String)uriInfo.getUsername()).isEqualTo(username);
        Assertions.assertThat((String)uriInfo.getPassword()).isEqualTo(password);
    }

    private void assertHostPort(UriInfo uriInfo) {
        Assertions.assertThat((String)uriInfo.getHost()).isEqualTo(hostname);
        Assertions.assertThat((int)uriInfo.getPort()).isEqualTo(1234);
    }

    @SpringBootApplication
    static class TestApp {
        TestApp() {
        }
    }
}

