/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.unsigned_indices_model;

import io.pinecone.proto.SparseValues;
import io.pinecone.utils.SparseIndicesConverter;
import java.util.Collections;
import java.util.List;

public class SparseValuesWithUnsignedIndices {
    private List<Long> indicesWithUnsigned32Int;
    private List<Float> values;

    public SparseValuesWithUnsignedIndices() {
        this.indicesWithUnsigned32Int = Collections.emptyList();
        this.values = Collections.emptyList();
    }

    public SparseValuesWithUnsignedIndices(List<Long> indicesWithUnsigned32Int, List<Float> values) {
        this.indicesWithUnsigned32Int = indicesWithUnsigned32Int;
        this.values = values;
    }

    public SparseValuesWithUnsignedIndices(SparseValues sparseValues) {
        if (sparseValues == null) {
            this.indicesWithUnsigned32Int = Collections.emptyList();
            this.values = Collections.emptyList();
        } else {
            this.indicesWithUnsigned32Int = SparseIndicesConverter.convertSigned32IntToUnsigned32Int(sparseValues.getIndicesList());
            this.values = sparseValues.getValuesList();
        }
    }

    public List<Long> getIndicesWithUnsigned32IntList() {
        return this.indicesWithUnsigned32Int;
    }

    public void setIndicesWithUnsigned32Int(List<Long> indicesWithUnsigned32Int) {
        this.indicesWithUnsigned32Int = indicesWithUnsigned32Int;
    }

    public List<Float> getValuesList() {
        return this.values;
    }

    public void setValues(List<Float> values) {
        this.values = values;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SparseValuesWithUnsignedIndices {").append("\n");
        sb.append("    indicesWithUnsigned32Int: ").append(this.toIndentedString(this.indicesWithUnsigned32Int)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }
}

