/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java9;

import io.perfmark.impl.Mark;
import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.Marker;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;

final class VarHandleMarkHolder
extends MarkHolder {
    private static final long GEN_MASK = 255L;
    private static final long START_OP = Mark.Operation.TASK_START.ordinal();
    private static final long START_NOTAG_OP = Mark.Operation.TASK_NOTAG_START.ordinal();
    private static final long STOP_OP = Mark.Operation.TASK_END.ordinal();
    private static final long STOP_NOTAG_OP = Mark.Operation.TASK_NOTAG_END.ordinal();
    private static final long EVENT_OP = Mark.Operation.EVENT.ordinal();
    private static final long EVENT_NOTAG_OP = Mark.Operation.EVENT_NOTAG.ordinal();
    private static final long LINK_OP = Mark.Operation.LINK.ordinal();
    private static final VarHandle IDX;
    private static final VarHandle OBJECTS;
    private static final VarHandle STRINGS;
    private static final VarHandle LONGS;
    private final int maxEvents;
    private final long maxEventsMax;
    private volatile long idx;
    private final Object[] taskNameOrMarkers;
    private final String[] tagNames;
    private final long[] tagIds;
    private final long[] nanoTimes;
    private final long[] durationNanoTimes;
    private final long[] genOps;

    VarHandleMarkHolder() {
        this(32768);
    }

    VarHandleMarkHolder(int maxEvents) {
        if ((maxEvents - 1 & maxEvents) != 0) {
            throw new IllegalArgumentException(maxEvents + " is not a power of two");
        }
        if (maxEvents <= 0) {
            throw new IllegalArgumentException(maxEvents + " is not positive");
        }
        this.maxEvents = maxEvents;
        this.maxEventsMax = (long)maxEvents - 1L;
        this.taskNameOrMarkers = new Object[maxEvents];
        this.tagNames = new String[maxEvents];
        this.tagIds = new long[maxEvents];
        this.nanoTimes = new long[maxEvents];
        this.durationNanoTimes = new long[maxEvents];
        this.genOps = new long[maxEvents];
    }

    public void start(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, taskName);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + START_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void start(long gen, Marker marker, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, marker);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + START_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void start(long gen, String taskName, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, taskName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + START_NOTAG_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void start(long gen, Marker marker, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, marker);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + START_NOTAG_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void link(long gen, long linkId, Marker marker) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        LONGS.setOpaque(this.tagIds, i, linkId);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, marker);
        LONGS.setOpaque(this.genOps, i, gen + LINK_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void stop(long gen, String taskName, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, taskName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + STOP_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void stop(long gen, Marker marker, String tagName, long tagId, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, marker);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + STOP_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void stop(long gen, String taskName, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, taskName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + STOP_NOTAG_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void stop(long gen, Marker marker, long nanoTime) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, marker);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.genOps, i, gen + STOP_NOTAG_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void event(long gen, String eventName, String tagName, long tagId, long nanoTime, long durationNanos) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, eventName);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.durationNanoTimes, i, durationNanos);
        LONGS.setOpaque(this.genOps, i, gen + EVENT_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void event(long gen, Marker marker, String tagName, long tagId, long nanoTime, long durationNanos) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, marker);
        STRINGS.setOpaque(this.tagNames, i, tagName);
        LONGS.setOpaque(this.tagIds, i, tagId);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.durationNanoTimes, i, durationNanos);
        LONGS.setOpaque(this.genOps, i, gen + EVENT_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void event(long gen, String eventName, long nanoTime, long durationNanos) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, eventName);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.durationNanoTimes, i, durationNanos);
        LONGS.setOpaque(this.genOps, i, gen + EVENT_NOTAG_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void event(long gen, Marker marker, long nanoTime, long durationNanos) {
        long localIdx = IDX.get(this);
        int i = (int)(localIdx & this.maxEventsMax);
        OBJECTS.setOpaque(this.taskNameOrMarkers, i, marker);
        LONGS.setOpaque(this.nanoTimes, i, nanoTime);
        LONGS.setOpaque(this.durationNanoTimes, i, durationNanos);
        LONGS.setOpaque(this.genOps, i, gen + EVENT_NOTAG_OP);
        IDX.setRelease(this, localIdx + 1L);
        VarHandle.storeStoreFence();
    }

    public void resetForTest() {
        Arrays.fill(this.taskNameOrMarkers, null);
        Arrays.fill(this.tagNames, null);
        Arrays.fill(this.tagIds, 0L);
        Arrays.fill(this.nanoTimes, 0L);
        Arrays.fill(this.durationNanoTimes, 0L);
        Arrays.fill(this.genOps, 0L);
        IDX.setRelease(this, 0L);
        VarHandle.storeStoreFence();
    }

    public List<Mark> read(boolean readerIsWriter) {
        Object[] localTaskNameOrMarkers = new Object[this.maxEvents];
        String[] localTagNames = new String[this.maxEvents];
        long[] localTagIds = new long[this.maxEvents];
        long[] localNanoTimes = new long[this.maxEvents];
        long[] localGenOps = new long[this.maxEvents];
        long startIdx = IDX.getOpaque(this);
        VarHandle.loadLoadFence();
        int size = (int)Math.min(startIdx, (long)this.maxEvents);
        for (int i = 0; i < size; ++i) {
            localTaskNameOrMarkers[i] = OBJECTS.getOpaque(this.taskNameOrMarkers, i);
            localTagNames[i] = STRINGS.getOpaque(this.tagNames, i);
            localTagIds[i] = LONGS.getOpaque(this.tagIds, i);
            localNanoTimes[i] = LONGS.getOpaque(this.nanoTimes, i);
            localGenOps[i] = LONGS.getOpaque(this.genOps, i);
        }
        VarHandle.loadLoadFence();
        long endIdx = IDX.getOpaque(this);
        if (endIdx < startIdx) {
            throw new AssertionError();
        }
        boolean tailValid = readerIsWriter || endIdx < (long)(this.maxEvents - 1);
        long eventsToDrop = (endIdx += !tailValid ? 1L : 0L) - startIdx;
        ArrayDeque<Mark> marks = new ArrayDeque<Mark>(size);
        int i = 0;
        while ((long)i < (long)size - eventsToDrop) {
            int readIdx = (int)(startIdx - (long)i - 1L & this.maxEventsMax);
            long gen = localGenOps[readIdx] & 0xFFFFFFFFFFFFFF00L;
            Mark.Operation op = Mark.Operation.valueOf((int)((int)(localGenOps[readIdx] & 0xFFL)));
            if (op == Mark.Operation.NONE) {
                throw new ConcurrentModificationException("Read of storage was not threadsafe");
            }
            Object taskNameOrMarker = localTaskNameOrMarkers[readIdx];
            if (taskNameOrMarker instanceof Marker) {
                marks.addFirst(Mark.create((Marker)((Marker)taskNameOrMarker), (String)localTagNames[readIdx], (long)localTagIds[readIdx], (long)localNanoTimes[readIdx], (long)gen, (Mark.Operation)op));
            } else if (taskNameOrMarker instanceof String) {
                marks.addFirst(Mark.create((String)((String)taskNameOrMarker), (String)localTagNames[readIdx], (long)localTagIds[readIdx], (long)localNanoTimes[readIdx], (long)gen, (Mark.Operation)op));
            } else {
                throw new RuntimeException("Bad marker or string " + taskNameOrMarker);
            }
            ++i;
        }
        return Collections.unmodifiableList(new ArrayList(marks));
    }

    public int maxMarks() {
        return this.maxEvents;
    }

    static {
        try {
            IDX = MethodHandles.lookup().findVarHandle(VarHandleMarkHolder.class, "idx", Long.TYPE);
            OBJECTS = MethodHandles.arrayElementVarHandle(Object[].class);
            STRINGS = MethodHandles.arrayElementVarHandle(String[].class);
            LONGS = MethodHandles.arrayElementVarHandle(long[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

