/*
 * Decompiled with CFR 0.152.
 */
package io.perfmark.java6;

import io.perfmark.impl.MarkHolder;
import io.perfmark.impl.MarkRecorder;
import io.perfmark.impl.MarkRecorderRef;
import io.perfmark.impl.Storage;
import io.perfmark.java6.SynchronizedMarkHolder;

final class SecretMarkRecorder {
    private SecretMarkRecorder() {
    }

    public static final class SynchronizedMarkRecorder
    extends MarkRecorder {
        private static final long START_N1S1_OP = 1L;
        private static final long START_N1S2_OP = 2L;
        private static final long STOP_N1S0_OP = 3L;
        private static final long STOP_N1S1_OP = 4L;
        private static final long STOP_N1S2_OP = 5L;
        private static final long EVENT_N1S1_OP = 6L;
        private static final long EVENT_N1S2_OP = 7L;
        private static final long EVENT_N2S2_OP = 8L;
        private static final long LINK_OP = 10L;
        private static final long TAG_N1S1_OP = 13L;
        private static final long TAG_KEYED_N0S2_OP = 16L;
        private static final long TAG_KEYED_N1S1_OP = 14L;
        private static final long TAG_KEYED_N2S1_OP = 15L;
        private static final LocalHolder localMarkHolder = new LocalHolder();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(long gen, String taskName) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeTs(gen + 1L, taskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(long gen, String taskName, String subTaskName) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeTss(gen + 2L, taskName, subTaskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(long gen, String taskName, String tagName, long tagId) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeTs(gen + 1L, taskName);
                holder.writeNs(gen + 13L, tagId, tagName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startAt(long gen, String taskName, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 1L, nanoTime, taskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startAt(long gen, String taskName, String subTaskName, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNss(gen + 2L, nanoTime, taskName, subTaskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startAt(long gen, String taskName, String tagName, long tagId, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 1L, nanoTime, taskName);
                holder.writeNs(gen + 13L, tagId, tagName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(long gen) {
            SynchronizedMarkHolder holder;
            long nanoTime = System.nanoTime();
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeN(gen + 3L, nanoTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(long gen, String taskName) {
            SynchronizedMarkHolder holder;
            long nanoTime = System.nanoTime();
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 4L, nanoTime, taskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(long gen, String taskName, String subTaskName) {
            SynchronizedMarkHolder holder;
            long nanoTime = System.nanoTime();
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNss(gen + 5L, nanoTime, taskName, subTaskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(long gen, String taskName, String tagName, long tagId) {
            SynchronizedMarkHolder holder;
            long nanoTime = System.nanoTime();
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 13L, tagId, tagName);
                holder.writeNs(gen + 4L, nanoTime, taskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAt(long gen, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeN(gen + 3L, nanoTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAt(long gen, String taskName, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 4L, nanoTime, taskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAt(long gen, String taskName, String subTaskName, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNss(gen + 5L, nanoTime, taskName, subTaskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopAt(long gen, String taskName, String tagName, long tagId, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 13L, tagId, tagName);
                holder.writeNs(gen + 4L, nanoTime, taskName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(long gen, String eventName) {
            SynchronizedMarkHolder holder;
            long nanoTime = System.nanoTime();
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 6L, nanoTime, eventName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(long gen, String eventName, String subEventName) {
            SynchronizedMarkHolder holder;
            long nanoTime = System.nanoTime();
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNss(gen + 7L, nanoTime, eventName, subEventName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(long gen, String eventName, String tagName, long tagId) {
            SynchronizedMarkHolder holder;
            long nanoTime = System.nanoTime();
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNnss(gen + 8L, nanoTime, tagId, eventName, tagName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventAt(long gen, String eventName, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 6L, nanoTime, eventName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventAt(long gen, String eventName, String subEventName, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNss(gen + 7L, nanoTime, eventName, subEventName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void eventAt(long gen, String eventName, String tagName, long tagId, long nanoTime) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNnss(gen + 8L, nanoTime, tagId, eventName, tagName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void link(long gen, long linkId) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeN(gen + 10L, linkId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachTag(long gen, String tagName, long tagId) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 13L, tagId, tagName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachKeyedTag(long gen, String name, long value0) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNs(gen + 14L, value0, name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachKeyedTag(long gen, String name, String value) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeSs(gen + 16L, name, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void attachKeyedTag(long gen, String name, long value0, long value1) {
            SynchronizedMarkHolder holder;
            SynchronizedMarkHolder synchronizedMarkHolder = holder = (SynchronizedMarkHolder)((Object)localMarkHolder.get());
            synchronized (synchronizedMarkHolder) {
                holder.writeNns(gen + 15L, value0, value1, name);
            }
        }

        static SynchronizedMarkHolder getLocalMarkHolder() {
            return localMarkHolder.getNoInit();
        }

        static void clearLocalMarkHolder() {
            localMarkHolder.remove();
        }

        static void setLocalMarkHolder(SynchronizedMarkHolder holder) {
            localMarkHolder.set(holder);
        }

        private static final class LocalHolder
        extends ThreadLocal<SynchronizedMarkHolder> {
            @Override
            protected SynchronizedMarkHolder initialValue() {
                SynchronizedMarkHolder holder = new SynchronizedMarkHolder(32768, MarkRecorderRef.newRef());
                Storage.registerMarkHolder((MarkHolder)holder);
                return holder;
            }

            SynchronizedMarkHolder getNoInit() {
                return (SynchronizedMarkHolder)((Object)super.get());
            }

            LocalHolder() {
            }
        }
    }
}

